/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.ContainerWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class DeleteNodeCommand
extends Command {
    private NodeWrapper child;
    private ContainerWrapper parent;
    private List<DeleteNodeCommand> embeddedCommands;
    private List<NodeWrapper> incomingElementWrappers = new ArrayList<NodeWrapper>();
    private List<NodeWrapper> outgoingElementWrappers = new ArrayList<NodeWrapper>();
    private List<ConnectionWrapper> incomingConnections = new ArrayList<ConnectionWrapper>();
    private List<ConnectionWrapper> outgoingConnections = new ArrayList<ConnectionWrapper>();

    private void deleteConnections(NodeWrapper element) {
        for (ConnectionWrapper connection : element.getIncomingConnections()) {
            this.incomingElementWrappers.add(connection.getSource());
            this.incomingConnections.add(connection);
        }
        for (ConnectionWrapper connection : element.getOutgoingConnections()) {
            this.outgoingElementWrappers.add(connection.getTarget());
            this.outgoingConnections.add(connection);
        }
        for (ConnectionWrapper connection : this.incomingConnections) {
            connection.disconnect();
        }
        for (ConnectionWrapper connection : this.outgoingConnections) {
            connection.disconnect();
        }
    }

    private void initializeEmbeddedCommands() {
        this.embeddedCommands = new ArrayList<DeleteNodeCommand>();
        ContainerWrapper container = (ContainerWrapper)((Object)this.child);
        List<NodeWrapper> children = container.getNodeWrappers();
        for (NodeWrapper w : children) {
            DeleteNodeCommand c = new DeleteNodeCommand();
            c.setParent(container);
            c.setChild(w);
            this.embeddedCommands.add(c);
        }
    }

    private void executeEmbeddedCommands() {
        if (this.embeddedCommands == null) {
            this.initializeEmbeddedCommands();
        }
        for (DeleteNodeCommand c : this.embeddedCommands) {
            c.execute();
        }
    }

    public void execute() {
        if (this.child instanceof ContainerWrapper) {
            this.executeEmbeddedCommands();
        }
        this.deleteConnections(this.child);
        this.parent.removeElement(this.child);
    }

    private void restoreConnections() {
        int i = 0;
        for (ConnectionWrapper connection : this.incomingConnections) {
            connection.connect(this.incomingElementWrappers.get(i), this.child);
            ++i;
        }
        i = 0;
        for (ConnectionWrapper connection : this.outgoingConnections) {
            connection.connect(this.child, this.outgoingElementWrappers.get(i));
            ++i;
        }
        this.incomingConnections.clear();
        this.incomingElementWrappers.clear();
        this.outgoingConnections.clear();
        this.outgoingElementWrappers.clear();
    }

    public void setChild(NodeWrapper child) {
        this.child = child;
    }

    public void setParent(ContainerWrapper parent) {
        this.parent = parent;
    }

    private void undoEmbeddedCommands() {
        for (DeleteNodeCommand c : this.embeddedCommands) {
            c.undo();
        }
    }

    public void undo() {
        this.parent.addElement(this.child);
        this.restoreConnections();
        if (this.child instanceof ContainerWrapper) {
            this.undoEmbeddedCommands();
        }
    }
}

