/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.command;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class ReconnectElementConnectionSourceCommand
extends Command {
    private ConnectionWrapper connection;
    private NodeWrapper target;
    private NodeWrapper oldSource;
    private NodeWrapper newSource;

    public boolean canExecute() {
        if (this.connection.getTarget().equals(this.newSource)) {
            return false;
        }
        for (ConnectionWrapper connection : this.newSource.getOutgoingConnections()) {
            if (!connection.getTarget().equals(this.target) || connection.getSource().equals(this.oldSource)) continue;
            return false;
        }
        return this.newSource.acceptsOutgoingConnection(this.connection, this.target);
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.disconnect();
            this.connection.connect(this.newSource, this.target);
        }
    }

    public void setSource(NodeWrapper source) {
        this.newSource = source;
    }

    public void setConnection(ConnectionWrapper connection) {
        this.connection = connection;
        this.target = connection.getTarget();
        this.oldSource = connection.getSource();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.oldSource, this.target);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.newSource, this.target);
    }
}

