/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.editpart;

import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.jboss.tools.flow.common.policy.ElementContainerLayoutEditPolicy;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootEditPart
extends AbstractGraphicalEditPart
implements ModelListener {
    private FlowWrapper getWrapper() {
        return (FlowWrapper)this.getModel();
    }

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setLayoutManager((LayoutManager)new XYLayout());
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ElementContainerLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    protected List<NodeWrapper> getModelChildren() {
        return this.getWrapper().getNodeWrappers();
    }

    public void activate() {
        super.activate();
        this.getWrapper().addListener(this);
    }

    public void deactivate() {
        this.getWrapper().removeListener(this);
        super.deactivate();
    }

    @Override
    public void modelChanged(ModelEvent event) {
        if (event.getChangeType() == 6) {
            this.refreshChildren();
        } else if (event.getChangeType() == 7) {
            this.refreshChildren();
        } else if (event.getChangeType() == 5) {
            this.refreshVisuals();
        }
    }

    public Object getAdapter(Class adapter) {
        Boolean val;
        if (adapter == SnapToHelper.class && (val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
            return new SnapToGrid((GraphicalEditPart)this);
        }
        return super.getAdapter(adapter);
    }

    protected void refreshVisuals() {
        Animation.markBegin();
        ConnectionLayer layer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((this.getViewer().getControl().getStyle() & 0x8000000) == 0) {
            layer.setAntialias(1);
        }
        if (this.getWrapper().getRouterLayout().equals(FlowWrapper.ROUTER_LAYOUT_MANUAL)) {
            FanRouter router = new FanRouter();
            router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            layer.setConnectionRouter((ConnectionRouter)router);
        } else if (this.getWrapper().getRouterLayout().equals(FlowWrapper.ROUTER_LAYOUT_MANHATTAN)) {
            layer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        } else {
            layer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter(this.getFigure()));
        }
        Animation.run((int)400);
    }
}

