/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.flow.common.wrapper.AbstractWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowWrapper
extends AbstractWrapper
implements FlowWrapper {
    private Map<String, NodeWrapper> nodeWrapperMap = new HashMap<String, NodeWrapper>();
    private List<NodeWrapper> nodeWrapperList = new ArrayList<NodeWrapper>();

    @Override
    public abstract Integer getRouterLayout();

    public void setRouterLayout(Integer newLayout) {
        Integer oldLayout = this.getRouterLayout();
        this.internalSetRouterLayout(newLayout);
        this.notifyListeners(5, "routerLayout", this, oldLayout, newLayout);
    }

    protected void internalSetRouterLayout(Integer routerLayout) {
    }

    @Override
    public List<NodeWrapper> getNodeWrappers() {
        return Collections.unmodifiableList(new ArrayList<NodeWrapper>(this.nodeWrapperList));
    }

    @Override
    public NodeWrapper getNodeWrapper(String id) {
        return this.nodeWrapperMap.get(id);
    }

    @Override
    public void addElement(NodeWrapper nodeWrapper) {
        if (!this.acceptsElement(nodeWrapper)) {
            return;
        }
        this.internalAddElement(nodeWrapper);
        this.localAddElement(nodeWrapper);
        this.notifyListeners(6, "node", this, null, nodeWrapper);
    }

    @Override
    public void localAddElement(NodeWrapper element) {
        this.nodeWrapperMap.put(element.getId(), element);
        this.nodeWrapperList.add(element);
        element.setParent(this);
    }

    @Override
    public boolean acceptsElement(NodeWrapper element) {
        return true;
    }

    protected abstract void internalAddElement(NodeWrapper var1);

    public void localRemoveElement(NodeWrapper element) {
        this.nodeWrapperMap.remove(element.getId());
        this.nodeWrapperList.remove(element);
    }

    @Override
    public void removeElement(NodeWrapper element) {
        this.localRemoveElement(element);
        this.internalRemoveElement(element);
        this.notifyListeners(7, "node", this, element, null);
    }

    protected abstract void internalRemoveElement(NodeWrapper var1);

    @Override
    public FlowWrapper getFlowWrapper() {
        return this;
    }
}

