/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.jbpm.preferences.PreferencesManager;

public abstract class AddJbpmInstallationDialog
extends StatusDialog {
    private static final String ENTER_NAME = "Enter the name of the jBPM installation.";
    private static final String ENTER_LOCATION = "Enter the location of the jBPM installation.";
    private static final String UNEXISTING_LOCATION = "The location does not exist.";
    private static final String NAME_ALREADY_USED = "The name is already used.";
    private static final String INVALID_JBPM_INSTALLATION = "This is not a valid jBPM installation.";
    private Plugin plugin;
    String title;
    Text nameText;
    Text locationText;
    Button locationButton;
    IStatus currentStatus;
    String name;
    String location;
    IStatus status;

    public AddJbpmInstallationDialog(Shell parentShell, Plugin plugin) {
        super(parentShell);
        this.plugin = plugin;
    }

    public void initialize(String t, String n, String l) {
        this.title = t;
        this.name = n;
        this.location = l;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        area.setLayout((Layout)gridLayout);
        this.createNameLabel(area);
        this.createNameText(area);
        this.createFillLabel(area);
        this.createLocationLabel(area);
        this.createLocationText(area);
        this.createLocationButton(area);
        this.getShell().setText(this.title);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateCurrentStatus();
        return result;
    }

    private void createLocationText(Composite area) {
        this.locationText = new Text(area, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.locationText.setLayoutData((Object)gridData);
        this.locationText.setText(this.location == null ? "" : this.location);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJbpmInstallationDialog.this.handleLocationChanged();
            }
        });
    }

    private void handleLocationChanged() {
        this.location = this.locationText.getText();
        this.updateCurrentStatus();
    }

    private void createLocationButton(Composite area) {
        this.locationButton = new Button(area, 8);
        this.locationButton.setText("Search...");
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJbpmInstallationDialog.this.searchLocation();
            }
        });
    }

    private void searchLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
        }
    }

    private void createLocationLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Location :");
    }

    private void createFillLabel(Composite area) {
        new Label(area, 0);
    }

    private void createNameText(Composite area) {
        this.nameText = new Text(area, 2048);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.setText(this.name == null ? "" : this.name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJbpmInstallationDialog.this.handleNameChanged();
            }
        });
    }

    private void handleNameChanged() {
        this.name = this.nameText.getText();
        this.updateCurrentStatus();
    }

    private IStatus getStatus(int severity, String str) {
        return new Status(severity, this.plugin.getBundle().getSymbolicName(), str, null);
    }

    private void updateCurrentStatus() {
        this.currentStatus = this.isNameEmpty() && this.isLocationEmpty() ? this.getStatus(1, ENTER_NAME) : (this.isNameAlreadyUsed() && !"Edit Location".equals(this.title) ? this.getStatus(4, NAME_ALREADY_USED) : (this.isLocationEmpty() ? this.getStatus(1, ENTER_LOCATION) : (!this.isLocationExisting() ? this.getStatus(4, UNEXISTING_LOCATION) : (!this.isValidJbpmInstallation() ? this.getStatus(4, INVALID_JBPM_INSTALLATION) : (this.isNameEmpty() ? this.getStatus(1, ENTER_NAME) : Status.OK_STATUS)))));
        this.updateStatus(this.currentStatus);
    }

    private boolean isNameAlreadyUsed() {
        return PreferencesManager.getPreferencesManager(this.plugin).getJbpmInstallation(this.nameText.getText()) != null;
    }

    private boolean isLocationExisting() {
        return new Path(this.location).toFile().exists();
    }

    private boolean isNameEmpty() {
        return this.name == null || "".equals(this.name);
    }

    private boolean isLocationEmpty() {
        return this.location == null || "".equals(this.location);
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    private void createNameLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Name :");
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    protected abstract String getVersion();

    protected abstract boolean isValidJbpmInstallation();
}

