/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.jboss4;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jbpm.integration.jboss4.JBPMDeployerMBean;
import org.jbpm.integration.spi.DeploymentAdaptor;
import org.jbpm.integration.spi.DeploymentRef;
import org.jbpm.integration.spi.JBPMDeploymentMetaData;
import org.jbpm.internal.log.Log;

public class JBPMDeployer
extends SubDeployerSupport
implements SubDeployer,
JBPMDeployerMBean {
    private static final Log log = Log.getLog((String)JBPMDeployer.class.getName());
    private DeploymentAdaptor adaptor;
    private static final String ARCHIVE_SUFFIX = ".jpdl";
    private static final String JPDL_FILE_SUFFIX = ".jpdl.xml";
    private static final String CONTEXT_REFERENCE = "jbpm.deployer.reference";

    public JBPMDeployer() {
        this.initializeMainDeployer();
        this.adaptor = new DeploymentAdaptor();
    }

    protected void initializeMainDeployer() {
        this.setSuffixes(new String[]{ARCHIVE_SUFFIX, JPDL_FILE_SUFFIX});
        this.setRelativeOrder(1000);
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith(ARCHIVE_SUFFIX) || urlStr.endsWith(JPDL_FILE_SUFFIX);
    }

    public void init(DeploymentInfo deploymentInfo) throws DeploymentException {
        super.init(deploymentInfo);
    }

    public void create(DeploymentInfo deploymentInfo) throws DeploymentException {
        super.create(deploymentInfo);
    }

    public void start(DeploymentInfo rootDeployment) throws DeploymentException {
        if (rootDeployment.url.getFile().endsWith(ARCHIVE_SUFFIX)) {
            log.info("Deploy " + rootDeployment.url);
            ArrayList<DeploymentRef> deploymentRefs = new ArrayList<DeploymentRef>();
            for (DeploymentInfo subDeployment : rootDeployment.subDeployments) {
                JBPMDeploymentMetaData md = new JBPMDeploymentMetaData();
                md.setClassloader((ClassLoader)subDeployment.localCl);
                md.setWatch(rootDeployment.watch);
                md.setProcessDescriptor(subDeployment.url);
                try {
                    DeploymentRef deploymentRef = this.adaptor.deploy(md);
                    deploymentRefs.add(deploymentRef);
                }
                catch (Throwable t) {
                    throw new DeploymentException(t);
                }
            }
            rootDeployment.context.put(CONTEXT_REFERENCE, deploymentRefs);
        }
    }

    public void destroy(DeploymentInfo deploymentInfo) {
        try {
            super.destroy(deploymentInfo);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(DeploymentInfo rootDeployment) {
        if (rootDeployment.url.getFile().endsWith(ARCHIVE_SUFFIX)) {
            log.info("Undeploy " + rootDeployment.url);
            List deploymentRefs = (List)rootDeployment.context.get(CONTEXT_REFERENCE);
            if (null == deploymentRefs) {
                log.info("Failed to retrieve process reference information. Ignore undepoyment call: " + rootDeployment.url);
                return;
            }
            this.adaptor.undeploy(deploymentRefs);
        }
    }
}

