/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashSet;
import java.util.Set;

import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;

/**
 * Command responsible for retrieving variable names stored as history records for given process instance id
 * 
 * 
 * @author Maciej Swiderski
 *
 */
public class GetHistoryVariableNamesCmd implements Command<Set<String>> {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  
  private String processInstanceId;
  
  public GetHistoryVariableNamesCmd(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  @SuppressWarnings("unchecked")
  public Set<String> execute(Environment environment) throws Exception {
    Session dbsession = environment.get(Session.class);
    
    String hql = "select hv.variableName from " + HistoryVariableImpl.class.getName() + " hv where hv.processInstanceId = '" + processInstanceId + "'";
    
    Query query = dbsession.createQuery(hql);
    
    Set<String> historyVariables = new HashSet<String>(query.list());
    
    return historyVariables;
  }

}
