/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.email.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressFilter {
    private List<Pattern> includePatterns;
    private List<Pattern> excludePatterns;

    public Address[] filter(Address ... addresses) {
        ArrayList<Address> filteredAddresses = new ArrayList<Address>();
        for (Address address : addresses) {
            if (!this.includeAddress(address) || this.excludeAddress(address)) continue;
            filteredAddresses.add(address);
        }
        return filteredAddresses.toArray(new Address[filteredAddresses.size()]);
    }

    protected boolean includeAddress(Address address) {
        if (this.includePatterns == null || this.includePatterns.isEmpty()) {
            return true;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(address.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean excludeAddress(Address address) {
        if (this.excludePatterns == null) {
            return false;
        }
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(address.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    public List<Pattern> getIncludePatterns() {
        return this.includePatterns;
    }

    public void addIncludePattern(Pattern includePattern) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<Pattern>();
        }
        this.includePatterns.add(includePattern);
    }

    protected void setIncludePatterns(List<Pattern> includePatterns) {
        this.includePatterns = includePatterns;
    }

    public List<Pattern> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void addExcludePattern(Pattern excludePattern) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<Pattern>();
        }
        this.excludePatterns.add(excludePattern);
    }

    protected void setExcludePatterns(List<Pattern> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }
}

