/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.svc.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeInterceptor
extends Interceptor {
    private static final Log log = Log.getLog((String)SerializeInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        log.info("serializing command " + command);
        Command serializedCommand = (Command)SerializeInterceptor.serialize(command);
        Object returnValue = this.next.execute(serializedCommand);
        return (T)SerializeInterceptor.serialize(returnValue);
    }

    private static Object serialize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new JbpmException("serialization exception", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

