/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jbpm.internal.log.Jdk14LogFactory;
import org.jbpm.internal.log.Log;
import org.jbpm.internal.log.LogFormatter;

public abstract class BaseJbpmTestCase
extends TestCase {
    protected static Log log;
    Throwable exception;

    protected void setUp() throws Exception {
        LogFormatter.resetIndentation();
        log.debug("=== starting " + this.getName() + " =============================");
    }

    protected void tearDown() throws Exception {
        log.debug("=== ending " + this.getName() + " =============================\n");
    }

    public void assertTextPresent(String expected, String value) {
        if (value == null || value.indexOf(expected) == -1) {
            BaseJbpmTestCase.fail((String)("expected presence of '" + expected + "' but was '" + value + "'"));
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            log.error("");
            log.error("ASSERTION FAILURE: " + e.getMessage(), (Throwable)e);
            log.error("");
            this.exception = e;
            throw e;
        }
        catch (Throwable t) {
            log.error("");
            log.error("TEST THROWS EXCEPTION: " + t.getMessage(), t);
            log.error("");
            this.exception = t;
            throw t;
        }
    }

    static {
        Jdk14LogFactory.initializeJdk14Logging();
        log = Log.getLog((String)BaseJbpmTestCase.class.getName());
    }
}

