/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.enterprise;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.test.enterprise.ArchiveDeployer;
import org.jbpm.test.enterprise.JBossArchiveDeployer;
import org.jbpm.test.enterprise.ObjectNameFactory;

public class IntegrationTestHelper {
    protected static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    protected static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    protected static String testResourcesDir;
    protected static String testArchiveDir;
    private static MBeanServerConnection server;
    private String integrationTarget;

    public void deploy(String[] archives) throws Exception {
        for (String archive : archives) {
            this.deploy(archive);
        }
    }

    public void deploy(String archive) throws Exception {
        URL url = IntegrationTestHelper.getTestArchiveFile(archive).toURI().toURL();
        this.deploy(url);
    }

    public void deploy(URL archive) throws Exception {
        this.getDeployer().deploy(archive);
    }

    public void undeploy(String[] archives) throws Exception {
        for (String archive : archives) {
            this.undeploy(archive);
        }
    }

    public void undeploy(String archive) throws Exception {
        File testArchiveFile = IntegrationTestHelper.getTestArchiveFile(archive);
        URL url = testArchiveFile.toURI().toURL();
        this.undeploy(url);
    }

    public void undeploy(URL archive) throws Exception {
        File testArchiveFile = IntegrationTestHelper.getTestArchiveFile(archive.getPath());
        File testArchiveFileTmp = new File(testArchiveFile.getAbsolutePath() + ".tmp");
        testArchiveFile.renameTo(testArchiveFileTmp);
        this.getDeployer().undeploy(archive);
        testArchiveFileTmp.renameTo(testArchiveFile);
    }

    public boolean isTargetJBoss500() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss500");
    }

    public boolean isTargetJBoss423() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss423");
    }

    public boolean isTargetJBoss422() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss422");
    }

    private String getIntegrationTarget() {
        if (this.integrationTarget == null) {
            String jbossVersion;
            try {
                ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
                jbossVersion = (String)this.getServer().getAttribute(oname, "SpecificationVersion");
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain jboss version", ex);
            }
            if (jbossVersion.startsWith("5.0.0")) {
                this.integrationTarget = "jboss500";
            } else if (jbossVersion.startsWith("4.2.3")) {
                this.integrationTarget = "jboss423";
            } else if (jbossVersion.startsWith("4.2.2")) {
                this.integrationTarget = "jboss422";
            } else {
                throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
            }
        }
        return this.integrationTarget;
    }

    public MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private ArchiveDeployer getDeployer() {
        return new JBossArchiveDeployer(this.getServer());
    }

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(this.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + this.getTestResourcesDir() + "/" + resource + "'");
    }

    public String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        }
        return testResourcesDir;
    }

    public static URL getTestArchiveURL(String archive) {
        try {
            return IntegrationTestHelper.getTestArchiveFile(archive).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to getTestArchiveURL", e);
        }
    }

    public static File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(IntegrationTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = IntegrationTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + IntegrationTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
        }
        return testArchiveDir;
    }
}

