/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.enterprise;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.management.MBeanServerConnection;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jbpm.internal.log.Log;
import org.jbpm.test.enterprise.IntegrationTestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationTestSetup
extends TestSetup {
    private IntegrationTestHelper delegate = new IntegrationTestHelper();
    private String[] archives;
    private ClassLoader originalClassLoader;
    private static final Log log = Log.getLog((String)IntegrationTestSetup.class.getName());

    public IntegrationTestSetup(Class<?> testClass, String ... archiveList) {
        super((Test)new TestSuite(testClass));
        this.archives = archiveList != null ? archiveList : new String[]{};
    }

    public File getArchiveFile(String archive) {
        return IntegrationTestHelper.getTestArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return IntegrationTestHelper.getTestArchiveFile(archive).toURI().toURL();
    }

    public boolean isTargetJBoss500() {
        return this.delegate.isTargetJBoss500();
    }

    public boolean isTargetJBoss423() {
        return this.delegate.isTargetJBoss423();
    }

    public boolean isTargetJBoss422() {
        return this.delegate.isTargetJBoss422();
    }

    public MBeanServerConnection getServer() {
        return this.delegate.getServer();
    }

    protected void setUp() throws Exception {
        ClassLoader parent;
        log.debug("### START SETUP " + this.getTest());
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            String archive = this.archives[i];
            try {
                this.delegate.deploy(archive);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.delegate.undeploy(archive);
            }
            if (!archive.endsWith("-client.jar")) continue;
            URL archiveURL = this.getArchiveURL(archive);
            clientJars.add(archiveURL);
        }
        this.originalClassLoader = parent = Thread.currentThread().getContextClassLoader();
        if (!clientJars.isEmpty()) {
            URL[] urls = new URL[clientJars.size()];
            for (int i = 0; i < clientJars.size(); ++i) {
                urls[i] = (URL)clientJars.get(i);
            }
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.archives.length; ++i) {
                String archive = this.archives[this.archives.length - i - 1];
                this.delegate.undeploy(archive);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        log.debug("### END SETUP " + this.getTest());
    }
}

