/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.cactustool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class CactusTestGenerator {
    private static final String excludedTests = System.getProperty("excluded.tests");
    private static final String suiteTests = System.getProperty("suite.tests");

    public static void main(String[] args) throws IOException {
        if (args == null) {
            CactusTestGenerator.log("syntax: java -cp ... org.jbpm.cactustool.CactusTestGenerator testdestroot testsrcroot1 testsrcroot2 ...");
        }
        if (excludedTests != null) {
            CactusTestGenerator.log("################################################################################################");
            CactusTestGenerator.log("# excluded tests: " + excludedTests);
            CactusTestGenerator.log("################################################################################################");
        }
        String testPackageSourceDir = args[0] + "/org/jbpm/test";
        new File(testPackageSourceDir).mkdirs();
        String testFileName = testPackageSourceDir + "/AllIntegrationTests.java";
        File testFile = new File(testFileName);
        FileOutputStream fos = new FileOutputStream(testFile);
        PrintWriter out = new PrintWriter(fos);
        CactusTestGenerator.log("generating java class " + testFile);
        out.println("package org.jbpm.test;");
        out.println();
        out.println("import junit.framework.Test;");
        out.println("import junit.framework.TestCase;");
        out.println("import org.apache.cactus.ServletTestSuite;");
        out.println();
        out.println("public class AllIntegrationTests extends TestCase {");
        out.println();
        out.println("  public static Test suite() {");
        out.println("    ServletTestSuite suite = new ServletTestSuite();");
        for (int i = 1; i < args.length; ++i) {
            String testSrcRoot = args[i];
            CactusTestGenerator.scanForTestClasses(testSrcRoot, "", out);
        }
        out.println("    return suite;");
        out.println("  }");
        out.println("}");
        out.close();
    }

    private static void scanForTestClasses(String dirPath, String packageName, PrintWriter out) throws IOException {
        File dirFile = new File(dirPath);
        if (".svn".equals(dirFile.getName())) {
            return;
        }
        CactusTestGenerator.log("scanning dir " + dirFile.getAbsolutePath());
        File[] dirContentFiles = dirFile.listFiles();
        if (dirContentFiles != null) {
            for (File file : dirContentFiles) {
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith("Test.java") && (excludedTests == null || !excludedTests.contains(fileName))) {
                    String className = packageName + "." + fileName.substring(0, fileName.length() - 5);
                    CactusTestGenerator.log("  adding " + className);
                    if (suiteTests == null || !suiteTests.contains(fileName)) {
                        out.println("    suite.addTestSuite(" + className + ".class);");
                        continue;
                    }
                    out.println("    suite.addTest(" + className + ".suite());");
                    continue;
                }
                if (!file.isDirectory()) continue;
                String subDirPath = dirPath + "/" + fileName;
                String subPackageName = "".equals(packageName) ? fileName : packageName + "." + fileName;
                CactusTestGenerator.scanForTestClasses(subDirPath, subPackageName, out);
            }
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }
}

