/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import junit.framework.Assert;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElement;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;
import org.jbpm.test.activities.WaitState;

public class EventTest
extends BaseJbpmTestCase {
    public void testEventListenerOnActivityEnd() {
        ActivityEndAction activityEndAction = new ActivityEndAction();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"leave activity action test").startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").listener((EventListener)activityEndAction).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        EventTest.assertTrue((boolean)processInstance.isActive("initial"));
        processInstance.signal();
        EventTest.assertEquals((Object)"Kilroy was here", (Object)processInstance.getVariable("msg"));
    }

    public void testEventListenerOnTransition() {
        TransitionAction transitionAction = new TransitionAction();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"transition action test").startActivity("initial", (ActivityBehaviour)new WaitState()).initial().startFlow("end").name("t").listener((EventListener)transitionAction).endFlow().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        EventTest.assertTrue((boolean)processInstance.isActive("initial"));
        processInstance.signal("t");
        EventTest.assertEquals((Object)"Kilroy was here", (Object)processInstance.getVariable("msg"));
    }

    public void testEventListenerOnActivityStart() {
        ActivityStartAction activityBeginAction = new ActivityStartAction();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"enter activity action test").startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).startEvent("start").listener((EventListener)activityBeginAction).endEvent().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        EventTest.assertTrue((boolean)processInstance.isActive("initial"));
        processInstance.signal();
        EventTest.assertEquals((Object)"Kilroy was here", (Object)processInstance.getVariable("msg"));
    }

    public void testCustomEventInActivity() {
        CheckRivetsAction checkRivetsAction = new CheckRivetsAction();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"custom activity action test").startActivity("initial", (ActivityBehaviour)new WaitStateWithCustomEvent()).initial().transition("end").startEvent("end of riveter shift").listener((EventListener)checkRivetsAction).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance execution = processDefinition.startProcessInstance();
        EventTest.assertTrue((boolean)execution.isActive("initial"));
        EventTest.assertNull((Object)execution.getVariable("msg"));
        execution.signal("end of riveter shift");
        EventTest.assertTrue((boolean)execution.isActive("initial"));
        EventTest.assertEquals((Object)"Kilroy was here", (Object)execution.getVariable("msg"));
        execution.signal();
        EventTest.assertTrue((boolean)execution.isActive("end"));
    }

    public static class EndState
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.end();
        }
    }

    public static class CheckRivetsAction
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            this.notify((ExecutionImpl)execution);
        }

        public void notify(ExecutionImpl execution) {
            execution.setVariable("msg", (Object)"Kilroy was here");
            Assert.assertTrue((boolean)execution.isActive("initial"));
            Assert.assertEquals((String)"initial", (String)execution.getEventSource().getName());
            Assert.assertEquals((String)"custom activity action test", (String)execution.getProcessDefinition().getName());
            Assert.assertNull((Object)execution.getTransition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitStateWithCustomEvent
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signal, Map<String, ?> parameters) throws Exception {
            this.signal((ExecutionImpl)execution, signal, parameters);
        }

        public void signal(ExecutionImpl execution, String signal, Map<String, ?> parameters) throws Exception {
            ActivityImpl activity = execution.getActivity();
            if (signal != null && activity != null && activity.hasEvent(signal)) {
                execution.fire(signal, (ObservableElement)activity);
                execution.waitForSignal();
            }
        }
    }

    public static class ActivityStartAction
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            this.notify((ExecutionImpl)execution);
        }

        public void notify(ExecutionImpl execution) {
            execution.setVariable("msg", (Object)"Kilroy was here");
            Assert.assertTrue((boolean)execution.isActive("end"));
            Assert.assertEquals((String)"end", (String)execution.getEventSource().getName());
            Assert.assertEquals((String)"enter activity action test", (String)execution.getProcessDefinition().getName());
            Assert.assertEquals((String)"end", (String)execution.getTransition().getDestination().getName());
        }
    }

    public static class TransitionAction
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            this.notify((ExecutionImpl)execution);
        }

        public void notify(ExecutionImpl execution) {
            execution.setVariable("msg", (Object)"Kilroy was here");
            Assert.assertEquals((String)"t", (String)execution.getEventSource().getName());
            Assert.assertEquals((String)"transition action test", (String)execution.getProcessDefinition().getName());
            Assert.assertEquals((String)"end", (String)execution.getTransition().getDestination().getName());
        }
    }

    public static class ActivityEndAction
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            this.notify((ExecutionImpl)execution);
        }

        public void notify(ExecutionImpl execution) {
            execution.setVariable("msg", (Object)"Kilroy was here");
            Assert.assertTrue((boolean)execution.isActive("initial"));
            Assert.assertEquals((String)"initial", (String)execution.getEventSource().getName());
            Assert.assertEquals((String)"leave activity action test", (String)execution.getProcessDefinition().getName());
            Assert.assertEquals((String)"end", (String)execution.getTransition().getDestination().getName());
        }
    }
}

