/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class ExceptionHandlerTest
extends BaseJbpmTestCase {
    public void testExceptionHandlerOnProcessDefinition() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startExceptionHandler(RuntimeException.class).listener((EventListener)catcher).endExceptionHandler().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        ExceptionHandlerTest.assertEquals((int)0, (int)catcher.timesInvoked);
        processInstance.signal();
        ExceptionHandlerTest.assertEquals((int)1, (int)catcher.timesInvoked);
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    public void testExceptionHandlerOnEvent() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").startExceptionHandler(RuntimeException.class).listener((EventListener)catcher).endExceptionHandler().listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        ExceptionHandlerTest.assertEquals((int)0, (int)catcher.timesInvoked);
        processInstance.signal();
        ExceptionHandlerTest.assertEquals((int)1, (int)catcher.timesInvoked);
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    public void testExceptionHandlerOnAction() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").listener((EventListener)new Batter()).startExceptionHandler(RuntimeException.class).listener((EventListener)catcher).endExceptionHandler().endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        ExceptionHandlerTest.assertEquals((int)0, (int)catcher.timesInvoked);
        processInstance.signal();
        ExceptionHandlerTest.assertEquals((int)1, (int)catcher.timesInvoked);
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    public void testExceptionHandlerOnOtherActivity() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).startExceptionHandler(RuntimeException.class).listener((EventListener)catcher).endExceptionHandler().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        ExceptionHandlerTest.assertEquals((int)0, (int)catcher.timesInvoked);
        try {
            processInstance.signal();
            ExceptionHandlerTest.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testExceptionHandlerOnOtherEvent() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("other").startExceptionHandler(RuntimeException.class).listener((EventListener)catcher).endExceptionHandler().endEvent().startEvent("end").listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        try {
            processInstance.signal();
            ExceptionHandlerTest.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testUnmatchedExceptionHandlerOnAction() {
        Catcher catcher = new Catcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").startExceptionHandler(NullPointerException.class).listener((EventListener)catcher).endExceptionHandler().listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ExceptionHandlerTest.assertTrue((boolean)processInstance.isActive("initial"));
        try {
            processInstance.signal();
            ExceptionHandlerTest.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testRethrowingExceptionHandler() {
        RethrowingCatcher rethrowingCatcher = new RethrowingCatcher();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("initial", (ActivityBehaviour)new WaitState()).initial().transition("end").startEvent("end").startExceptionHandler(RuntimeException.class).listener((EventListener)rethrowingCatcher).endExceptionHandler().listener((EventListener)new Batter()).endEvent().endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        try {
            processInstance.signal();
            ExceptionHandlerTest.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            this.assertTextPresent("greetz from the retrhowing catcher", e.getMessage());
        }
    }

    public static class RethrowingCatcher
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            throw new RuntimeException("greetz from the retrhowing catcher");
        }
    }

    public static class BehavedAction
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
        }
    }

    public static class Batter
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            throw new RuntimeException("catch me");
        }
    }

    public static class Catcher
    implements EventListener {
        private static final long serialVersionUID = 1L;
        int timesInvoked = 0;

        public void notify(EventListenerExecution execution) {
            ++this.timesInvoked;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }
}

