/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import junit.framework.Assert;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class ExecutionStateTest
extends BaseJbpmTestCase {
    public void testBasicState() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").endActivity().startActivity("c", (ActivityBehaviour)new AutomaticActivity()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        ExecutionStateTest.assertEquals((String)"created", (String)processInstance.getState());
        processInstance.start();
        ExecutionStateTest.assertEquals((String)"active-root", (String)processInstance.getState());
        processInstance.signal();
        ExecutionStateTest.assertEquals((String)"ended", (String)processInstance.getState());
    }

    public void testSignalOnInactiveExecution() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new AutomaticActivity()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ExecutionStateTest.assertEquals((String)"inactive-scope", (String)processInstance.getState());
        try {
            processInstance.signal();
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("process-instance is not active: inactive", e.getMessage());
        }
    }

    public void testCustomEndState() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").endActivity().startActivity("c", (ActivityBehaviour)new AutomaticActivity()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        processInstance.end("error");
        ExecutionStateTest.assertEquals((String)"error", (String)processInstance.getState());
        try {
            processInstance.signal();
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("process-instance is not active: error", e.getMessage());
        }
    }

    public void testInvalidCustomStates() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").endActivity().startActivity("c", (ActivityBehaviour)new AutomaticActivity()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        try {
            processInstance.end("created");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: created", e.getMessage());
        }
        try {
            processInstance.end("active-root");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: active-root", e.getMessage());
        }
        try {
            processInstance.end("active-concurrent");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: active-concurrent", e.getMessage());
        }
        try {
            processInstance.end("inactive-concurrent-root");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: inactive-concurrent-root", e.getMessage());
        }
        try {
            processInstance.end("inactive-scope");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: inactive-scope", e.getMessage());
        }
        try {
            processInstance.end("suspended");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: suspended", e.getMessage());
        }
        try {
            processInstance.end("async");
            ExecutionStateTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("invalid end state: async", e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
            execution.take(signalName);
        }
    }

    public static class AutomaticActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
        }
    }
}

