/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class FunctionalActivityTest
extends BaseJbpmTestCase {
    public void testFunctionalActivityAsActivityBehaviourWithTransitions() {
        ArrayList<String> recordedEvents = new ArrayList<String>();
        FunctionalActivity functionalActivity = new FunctionalActivity(recordedEvents);
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)functionalActivity).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)functionalActivity).transition("c").endActivity().startActivity("c", (ActivityBehaviour)functionalActivity).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        FunctionalActivityTest.assertFalse((boolean)processInstance.isEnded());
        FunctionalActivityTest.assertEquals(expectedEvents, recordedEvents);
        processInstance.start();
        expectedEvents.add("performed automatic activity");
        expectedEvents.add("performed automatic activity");
        expectedEvents.add("performed automatic activity");
        FunctionalActivityTest.assertEquals(expectedEvents, recordedEvents);
    }

    public void testFunctionalActivityAsEventListener() {
        ArrayList<String> recordedEvents = new ArrayList<String>();
        FunctionalActivity functionalActivity = new FunctionalActivity(recordedEvents);
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().startFlow("b").listener((EventListener)functionalActivity).endFlow().endActivity().startActivity("b", (ActivityBehaviour)new AutomaticActivity()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("performed automatic activity");
        FunctionalActivityTest.assertEquals(expectedEvents, recordedEvents);
    }

    public void testFunctionalActivityAsNestedActivity() {
        ArrayList<String> recordedEvents = new ArrayList<String>();
        FunctionalActivity functionalActivity = new FunctionalActivity(recordedEvents);
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new Composite()).initial().startActivity((ActivityBehaviour)functionalActivity).endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("performed automatic activity");
        FunctionalActivityTest.assertEquals(expectedEvents, recordedEvents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Composite
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            this.execute((ExecutionImpl)execution);
        }

        public void execute(ExecutionImpl execution) {
            Activity nestedActivity = (Activity)execution.getActivity().getActivities().get(0);
            execution.execute(nestedActivity);
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }

    public static class AutomaticActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionalActivity
    implements ActivityBehaviour,
    EventListener {
        private static final long serialVersionUID = 1L;
        List<String> events;

        public FunctionalActivity(List<String> events) {
            this.events = events;
        }

        public void execute(ActivityExecution execution) {
            this.perform((OpenExecution)execution);
        }

        public void notify(EventListenerExecution execution) {
            this.perform((OpenExecution)execution);
        }

        void perform(OpenExecution execution) {
            this.events.add("performed automatic activity");
        }
    }
}

