/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class LoopingTest
extends BaseJbpmTestCase {
    static List<Object> recordedIndexes = new ArrayList<Object>();

    public void testWhile() {
        int loops = 20;
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("for", (ActivityBehaviour)new For(loops)).initial().transition("recorder", "loop").transition("end", "done").endActivity().startActivity("recorder", (ActivityBehaviour)new Recorder()).transition("for").endActivity().startActivity("end", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ArrayList<Integer> expectedIndexes = new ArrayList<Integer>();
        for (int i = 0; i < loops; ++i) {
            expectedIndexes.add(i);
        }
        LoopingTest.assertEquals(expectedIndexes, recordedIndexes);
        LoopingTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }

    public static class Recorder
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            recordedIndexes.add(execution.getVariable("index"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class For
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;
        int startIndex = 0;
        int loops;
        int increment = 1;
        String indexKey = "index";

        public For(int loops) {
            this.loops = loops;
        }

        public void execute(ActivityExecution execution) throws Exception {
            Integer index = (Integer)execution.getVariable(this.indexKey);
            if (index == null) {
                execution.setVariable(this.indexKey, (Object)this.startIndex);
                execution.take("loop");
            } else {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                if (index < this.startIndex + this.loops) {
                    execution.setVariable(this.indexKey, (Object)index);
                    execution.take("loop");
                } else {
                    execution.removeVariable(this.indexKey);
                    execution.take("done");
                }
            }
        }

        public void signal(ActivityExecution execution, String signal, Map<String, ?> parameters) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public void setLoops(int loops) {
            this.loops = loops;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }

        public void setIndexVariable(String indexVariable) {
            this.indexKey = indexVariable;
        }
    }
}

