/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import junit.framework.Assert;
import org.jbpm.api.Execution;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class ScopeStateTest
extends BaseJbpmTestCase {
    public void testInactivationWhenCreatingNestedExecution() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new AutomaticActivity()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        ScopeStateTest.assertEquals((String)"created", (String)processInstance.getState());
        processInstance.start();
        Execution scopeExecution = (Execution)processInstance.getExecutions().iterator().next();
        ScopeStateTest.assertEquals((String)"inactive-scope", (String)processInstance.getState());
        ScopeStateTest.assertEquals((String)"active-root", (String)scopeExecution.getState());
        processInstance.signal(scopeExecution);
        ScopeStateTest.assertEquals((String)"ended", (String)scopeExecution.getState());
        ScopeStateTest.assertEquals((String)"active-root", (String)processInstance.getState());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
            execution.take(signalName);
        }
    }

    public static class AutomaticActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            Assert.assertEquals((String)"active-root", (String)execution.getState());
        }
    }
}

