/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class VariableTest
extends BaseJbpmTestCase {
    protected ClientProcessDefinition createProcessDefinition() {
        return ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().endActivity().endProcess();
    }

    public void testSetAndGetVariable() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        VariableTest.assertEquals((Object)"coca-cola", (Object)processInstance.getVariable("customer"));
        processInstance.setVariable("address", (Object)"usa");
        VariableTest.assertEquals((Object)"usa", (Object)processInstance.getVariable("address"));
        processInstance.setVariable("size", (Object)"big");
        VariableTest.assertEquals((Object)"big", (Object)processInstance.getVariable("size"));
    }

    public void testHasVariable() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        VariableTest.assertTrue((boolean)processInstance.hasVariable("customer"));
        VariableTest.assertFalse((boolean)processInstance.hasVariable("address"));
    }

    public void testSetVariables() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("customer", "coca-cola");
        variables.put("address", "usa");
        variables.put("size", "big");
        processInstance.setVariables(variables);
        VariableTest.assertEquals((Object)"coca-cola", (Object)processInstance.getVariable("customer"));
        VariableTest.assertEquals((Object)"usa", (Object)processInstance.getVariable("address"));
        VariableTest.assertEquals((Object)"big", (Object)processInstance.getVariable("size"));
    }

    public void testGetVariables() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        processInstance.setVariable("address", (Object)"usa");
        processInstance.setVariable("size", (Object)"big");
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("customer", "coca-cola");
        expectedVariables.put("address", "usa");
        expectedVariables.put("size", "big");
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
    }

    public void testRemoveVariable() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        processInstance.setVariable("address", (Object)"usa");
        processInstance.setVariable("size", (Object)"big");
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("customer", "coca-cola");
        expectedVariables.put("address", "usa");
        expectedVariables.put("size", "big");
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
        processInstance.removeVariable("address");
        expectedVariables.remove("address");
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
        processInstance.removeVariable("customer");
        expectedVariables.remove("customer");
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
        processInstance.removeVariable("size");
        expectedVariables.remove("size");
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
    }

    public void testRemoveVariables() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        processInstance.setVariable("address", (Object)"usa");
        processInstance.setVariable("size", (Object)"big");
        processInstance.removeVariables();
        HashMap expectedVariables = new HashMap();
        VariableTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
    }

    public void testGetVariableKeys() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        processInstance.setVariable("address", (Object)"usa");
        processInstance.setVariable("size", (Object)"big");
        HashSet<String> expectedVariableKeys = new HashSet<String>();
        expectedVariableKeys.add("customer");
        expectedVariableKeys.add("address");
        expectedVariableKeys.add("size");
        VariableTest.assertEquals(expectedVariableKeys, new HashSet(processInstance.getVariableKeys()));
    }

    public void testGetUnexistingVariable() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        VariableTest.assertNull((Object)processInstance.getVariable("answer to life, the universe and everything"));
    }

    public void testInitialiseVariablesBeforeProcessInstanceBegin() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new VariableActivity()).initial().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("customer", (Object)"coca-cola");
        processInstance.start();
        VariableTest.assertEquals((Object)"Killroy was here", (Object)processInstance.getVariable("message"));
    }

    public void testNullValue() {
        ClientProcessDefinition processDefinition = this.createProcessDefinition();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("niks", null);
        processInstance.setVariable("nada", null);
        VariableTest.assertTrue((boolean)processInstance.hasVariables());
        VariableTest.assertTrue((boolean)processInstance.hasVariable("niks"));
        VariableTest.assertTrue((boolean)processInstance.hasVariable("nada"));
        VariableTest.assertNull((Object)processInstance.getVariable("niks"));
        VariableTest.assertNull((Object)processInstance.getVariable("nada"));
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("niks");
        expectedKeys.add("nada");
        VariableTest.assertEquals(expectedKeys, new HashSet(processInstance.getVariableKeys()));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("niks", null);
        expectedVariables.put("nada", null);
        VariableTest.assertEquals(expectedVariables, new HashMap(processInstance.getVariables()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableActivity
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            Assert.assertEquals((Object)"coca-cola", (Object)execution.getVariable("customer"));
            execution.setVariable("message", (Object)"Killroy was here");
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }
}

