/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;
import org.jbpm.test.activities.WaitState;

public class TransitionEventsTest
extends BaseJbpmTestCase {
    public void testBasicEvents() {
        Recorder fromListener = new Recorder();
        Recorder toListener = new Recorder();
        Recorder transitionListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startActivity("from", (ActivityBehaviour)new WaitState()).initial().startEvent("end").listener((EventListener)fromListener).endEvent().startFlow("to").listener((EventListener)transitionListener).endFlow().endActivity().startActivity("to", (ActivityBehaviour)new WaitState()).startEvent("start").listener((EventListener)toListener).endEvent().endActivity().endProcess();
        ClientProcessInstance execution = processDefinition.startProcessInstance();
        execution.signal();
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(from)]", (String)fromListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(take) on (from)-->(to)]", (String)transitionListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(to)]", (String)toListener.events.toString());
    }

    public void testCompositeLeave() {
        Recorder processListener = new Recorder();
        Recorder outsideListener = new Recorder();
        Recorder compositeListener = new Recorder();
        Recorder insideListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener).endEvent().startEvent("start").listener((EventListener)processListener).endEvent().startEvent("take").listener((EventListener)processListener).endEvent().startActivity("composite").startEvent("end").listener((EventListener)compositeListener).endEvent().startEvent("start").listener((EventListener)compositeListener).endEvent().startEvent("take").listener((EventListener)compositeListener).endEvent().startActivity("inside", (ActivityBehaviour)new WaitState()).initial().transition("outside").startEvent("end").listener((EventListener)insideListener).endEvent().startEvent("start").listener((EventListener)insideListener).endEvent().startEvent("take").listener((EventListener)insideListener).endEvent().endActivity().endActivity().startActivity("outside", (ActivityBehaviour)new WaitState()).startEvent("end").listener((EventListener)outsideListener).endEvent().startEvent("start").listener((EventListener)outsideListener).endEvent().startEvent("take").listener((EventListener)outsideListener).endEvent().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)outsideListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)insideListener.events.size());
        TransitionEventsTest.assertTrue((boolean)processInstance.isActive("inside"));
        processInstance.signal();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(outside)]", (String)outsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(composite)]", (String)compositeListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(inside)]", (String)insideListener.events.toString());
    }

    public void testCompositeEnter() {
        Recorder processListener = new Recorder();
        Recorder outsideListener = new Recorder();
        Recorder compositeListener = new Recorder();
        Recorder insideListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener).endEvent().startEvent("start").listener((EventListener)processListener).endEvent().startEvent("take").listener((EventListener)processListener).endEvent().startActivity("outside", (ActivityBehaviour)new WaitState()).initial().transition("inside").startEvent("end").listener((EventListener)outsideListener).endEvent().startEvent("start").listener((EventListener)outsideListener).endEvent().startEvent("take").listener((EventListener)outsideListener).endEvent().endActivity().startActivity("composite").startEvent("end").listener((EventListener)compositeListener).endEvent().startEvent("start").listener((EventListener)compositeListener).endEvent().startEvent("take").listener((EventListener)compositeListener).endEvent().startActivity("inside", (ActivityBehaviour)new WaitState()).startEvent("end").listener((EventListener)insideListener).endEvent().startEvent("start").listener((EventListener)insideListener).endEvent().startEvent("take").listener((EventListener)insideListener).endEvent().endActivity().endActivity().endProcess();
        ClientProcessInstance execution = processDefinition.startProcessInstance();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)outsideListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)insideListener.events.size());
        execution.signal();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(outside)]", (String)outsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(composite)]", (String)compositeListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(inside)]", (String)insideListener.events.toString());
    }

    public void testSelfTransition() {
        Recorder processListener = new Recorder();
        Recorder compositeListener = new Recorder();
        Recorder insideListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener).endEvent().startEvent("start").listener((EventListener)processListener).endEvent().startEvent("take").listener((EventListener)processListener).endEvent().startActivity("composite").startEvent("end").listener((EventListener)compositeListener).endEvent().startEvent("start").listener((EventListener)compositeListener).endEvent().startEvent("take").listener((EventListener)compositeListener).endEvent().startActivity("inside", (ActivityBehaviour)new WaitState()).initial().transition("inside").startEvent("end").listener((EventListener)insideListener).endEvent().startEvent("start").listener((EventListener)insideListener).endEvent().startEvent("take").listener((EventListener)insideListener).endEvent().endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)insideListener.events.size());
        TransitionEventsTest.assertTrue((boolean)processInstance.isActive("inside"));
        processInstance.signal();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(inside), event(start) on activity(inside)]", (String)insideListener.events.toString());
    }

    public void testPropagateSelfTransition() {
        Recorder processListener = new Recorder();
        Recorder compositeListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener, true).endEvent().startEvent("start").listener((EventListener)processListener, true).endEvent().startEvent("take").listener((EventListener)processListener, true).endEvent().startActivity("composite").startEvent("end").listener((EventListener)compositeListener, true).endEvent().startEvent("start").listener((EventListener)compositeListener, true).endEvent().startEvent("take").listener((EventListener)compositeListener, true).endEvent().startActivity("inside", (ActivityBehaviour)new WaitState()).initial().transition("inside").endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertTrue((boolean)processInstance.isActive("inside"));
        processInstance.signal();
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(inside), event(take) on (inside)-->(inside), event(start) on activity(inside)]", (String)compositeListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p), event(end) on activity(inside), event(take) on (inside)-->(inside), event(start) on activity(inside)]", (String)processListener.events.toString());
    }

    public void testCompositeLeaveInheritedTransition() {
        Recorder processListener = new Recorder();
        Recorder outsideListener = new Recorder();
        Recorder compositeListener = new Recorder();
        Recorder insideListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener).endEvent().startEvent("start").listener((EventListener)processListener).endEvent().startEvent("take").listener((EventListener)processListener).endEvent().startActivity("composite").transition("outside").startEvent("end").listener((EventListener)compositeListener).endEvent().startEvent("start").listener((EventListener)compositeListener).endEvent().startEvent("take").listener((EventListener)compositeListener).endEvent().startActivity("inside", (ActivityBehaviour)new WaitState()).initial().startEvent("end").listener((EventListener)insideListener).endEvent().startEvent("start").listener((EventListener)insideListener).endEvent().startEvent("take").listener((EventListener)insideListener).endEvent().endActivity().endActivity().startActivity("outside", (ActivityBehaviour)new WaitState()).startEvent("end").listener((EventListener)outsideListener).endEvent().startEvent("start").listener((EventListener)outsideListener).endEvent().startEvent("take").listener((EventListener)outsideListener).endEvent().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((int)0, (int)outsideListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)compositeListener.events.size());
        TransitionEventsTest.assertEquals((int)0, (int)insideListener.events.size());
        TransitionEventsTest.assertTrue((boolean)processInstance.isActive("inside"));
        processInstance.signal();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(outside)]", (String)outsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(composite)]", (String)compositeListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(inside)]", (String)insideListener.events.toString());
    }

    public void testCompositeLeaveInheritedTransitionExtraNesting() {
        Recorder processListener = new Recorder();
        Recorder sourceOutsideListener = new Recorder();
        Recorder sourceMiddleListener = new Recorder();
        Recorder sourceInsideListener = new Recorder();
        Recorder destinationOutsideListener = new Recorder();
        Recorder destinationInsideListener = new Recorder();
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"p").startEvent("end").listener((EventListener)processListener).endEvent().startEvent("start").listener((EventListener)processListener).endEvent().startEvent("take").listener((EventListener)processListener).endEvent().startActivity("source outside").startEvent("end").listener((EventListener)sourceOutsideListener).endEvent().startEvent("start").listener((EventListener)sourceOutsideListener).endEvent().startEvent("take").listener((EventListener)sourceOutsideListener).endEvent().startActivity("source middle").transition("destination inside").startEvent("end").listener((EventListener)sourceMiddleListener).endEvent().startEvent("start").listener((EventListener)sourceMiddleListener).endEvent().startEvent("take").listener((EventListener)sourceMiddleListener).endEvent().startActivity("source inside", (ActivityBehaviour)new WaitState()).initial().startEvent("end").listener((EventListener)sourceInsideListener).endEvent().startEvent("start").listener((EventListener)sourceInsideListener).endEvent().startEvent("take").listener((EventListener)sourceInsideListener).endEvent().endActivity().endActivity().endActivity().startActivity("destination outside").startEvent("end").listener((EventListener)destinationOutsideListener).endEvent().startEvent("start").listener((EventListener)destinationOutsideListener).endEvent().startEvent("take").listener((EventListener)destinationOutsideListener).endEvent().startActivity("destination inside", (ActivityBehaviour)new WaitState()).startEvent("end").listener((EventListener)destinationInsideListener).endEvent().startEvent("start").listener((EventListener)destinationInsideListener).endEvent().startEvent("take").listener((EventListener)destinationInsideListener).endEvent().endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        TransitionEventsTest.assertTrue((boolean)processInstance.isActive("source inside"));
        processInstance.signal();
        TransitionEventsTest.assertEquals((String)"[event(start) on process(p)]", (String)processListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(source outside)]", (String)sourceOutsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(source middle)]", (String)sourceMiddleListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(end) on activity(source inside)]", (String)sourceInsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(destination outside)]", (String)destinationOutsideListener.events.toString());
        TransitionEventsTest.assertEquals((String)"[event(start) on activity(destination inside)]", (String)destinationInsideListener.events.toString());
    }

    public class Recorder
    implements EventListener {
        private static final long serialVersionUID = 1L;
        public List<Object> events = new ArrayList<Object>();

        public void notify(EventListenerExecution execution) {
            this.notify((ExecutionImpl)execution);
        }

        public void notify(ExecutionImpl execution) {
            this.events.add(execution.getEvent() + " on " + execution.getEventSource());
        }
    }
}

