/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.tomcat6;

import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmConsoleRealm
extends RealmBase {
    private String driverName;
    private String connectionUrl;
    private String connectionName;
    private String connectionPassword;
    private Driver driver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String user, String credentials) {
        Connection conn = null;
        try {
            conn = this.openConnection();
            Long userId = this.retrieveUserId(conn, user, credentials);
            if (userId != null) {
                List<String> roles = this.retrieveRoles(conn, userId);
                GenericPrincipal genericPrincipal = new GenericPrincipal((Realm)this, user, credentials, roles);
                return genericPrincipal;
            }
        }
        catch (Exception e) {
            this.containerLog.error((Object)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.containerLog.error((Object)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long retrieveUserId(Connection conn, String username, String password) throws SQLException {
        Long result = null;
        PreparedStatement stm = null;
        try {
            stm = conn.prepareStatement("SELECT DBID_ FROM JBPM4_ID_USER WHERE ID_=? AND PASSWORD_=?");
            stm.setString(1, username);
            stm.setString(2, password);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            stm.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> retrieveRoles(Connection conn, Long userDbId) throws SQLException {
        ArrayList<String> roles = new ArrayList<String>();
        PreparedStatement stm = null;
        try {
            stm = conn.prepareStatement("SELECT JBPM4_ID_GROUP.NAME_ FROM JBPM4_ID_GROUP INNER JOIN JBPM4_ID_MEMBERSHIP ON JBPM4_ID_MEMBERSHIP.GROUP_=JBPM4_ID_GROUP.DBID_ INNER JOIN JBPM4_ID_USER ON JBPM4_ID_MEMBERSHIP.USER_=JBPM4_ID_USER.DBID_ WHERE JBPM4_ID_USER.DBID_=?");
            stm.setLong(1, userDbId);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                roles.add(rs.getString(1));
            }
        }
        finally {
            stm.close();
        }
        return roles;
    }

    public Principal authenticate(String user, byte[] credentials) {
        return this.authenticate(user, new String(credentials));
    }

    public Principal authenticate(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7) {
        throw new UnsupportedOperationException();
    }

    protected String getPassword(String username) {
        throw new UnsupportedOperationException();
    }

    protected Principal getPrincipal(String userName) {
        throw new UnsupportedOperationException();
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getInfo() {
        return "JbpmConsoleRealm";
    }

    private Connection openConnection() throws SQLException {
        if (this.driver == null) {
            try {
                this.driver = (Driver)Class.forName(this.driverName).newInstance();
                DriverManager.setLoginTimeout(10);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate driver " + this.driverName);
            }
        }
        Properties props = new Properties();
        props.put("user", this.connectionName);
        props.put("password", this.connectionPassword);
        Connection conn = this.driver.connect(this.connectionUrl, props);
        conn.setReadOnly(true);
        return conn;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }
}

