/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.jpdl.internal.convert.Jpdl3ConverterParser;
import org.jbpm.jpdl.internal.convert.action.Action;
import org.jbpm.jpdl.internal.convert.action.ActionConverterTypes;
import org.jbpm.jpdl.internal.convert.action.CreateTimerAction;
import org.jbpm.jpdl.internal.convert.exception.ConvertException;
import org.jbpm.jpdl.internal.convert.node.Node;
import org.jbpm.jpdl.internal.convert.node.NodeConverterTypes;
import org.jbpm.jpdl.internal.convert.node.StartState;
import org.jbpm.jpdl.internal.convert.node.TaskNode;
import org.jbpm.jpdl.internal.convert.node.VariableAccess;
import org.jbpm.jpdl.internal.convert.problem.Problem;
import org.jbpm.jpdl.internal.convert.problem.ProblemListener;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jpdl3Converter
implements ProblemListener {
    private static final long serialVersionUID = 1L;
    protected InputSource inputSource;
    protected Document jpdl3Document;
    protected List<Problem> problems = new ArrayList<Problem>();
    protected ProblemListener problemListener;
    protected Document jpdl4Document;
    protected Collection<Object[]> unresolvedTransitionDestinations;
    protected Collection<Object[]> unresolvedActionReferences;
    protected Map<String, Element> nodeCollection = new ConcurrentHashMap<String, Element>();
    protected Map<String, Element> swimlanesCollection = new ConcurrentHashMap<String, Element>();
    private int timerNumber;
    private static final Log log = LogFactory.getLog(Jpdl3Converter.class);

    public Jpdl3Converter(URL url) {
        try {
            File file = new File(url.toURI());
            FileReader reader = new FileReader(file);
            this.inputSource = new InputSource(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Jpdl3Converter(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public Jpdl3Converter(Reader reader) {
        this(new InputSource(reader));
    }

    public void close() throws IOException {
        InputStream byteStream = this.inputSource.getByteStream();
        if (byteStream != null) {
            byteStream.close();
        } else {
            Reader charStream = this.inputSource.getCharacterStream();
            if (charStream != null) {
                charStream.close();
            }
        }
        this.jpdl3Document = null;
    }

    @Override
    public void addProblem(Problem problem) {
        this.problems.add(problem);
        if (this.problemListener != null) {
            this.problemListener.addProblem(problem);
        }
    }

    public void addError(String description) {
        log.error((Object)("invalid process xml: " + description));
        this.addProblem(new Problem(2, description));
    }

    public void addError(String description, Throwable exception) {
        log.error((Object)("invalid process xml: " + description), exception);
        this.addProblem(new Problem(2, description, exception));
    }

    public void addWarning(String description) {
        log.warn((Object)("process xml warning: " + description));
        this.addProblem(new Problem(3, description));
    }

    public Document readAndConvert() {
        this.jpdl4Document = DocumentHelper.createDocument();
        this.problems = new ArrayList<Problem>();
        this.unresolvedTransitionDestinations = new ArrayList<Object[]>();
        this.unresolvedActionReferences = new ArrayList<Object[]>();
        try {
            this.jpdl3Document = Jpdl3ConverterParser.parse(this.inputSource, this);
            this.jpdl4Document.setXMLEncoding(this.jpdl3Document.getXMLEncoding());
            Element jpdl3Root = this.jpdl3Document.getRootElement();
            Element jpdl4Root = this.parseProcessDefinitionAttributes(jpdl3Root);
            String description = jpdl3Root.elementTextTrim("description");
            if (description != null) {
                jpdl4Root.addComment(description);
            }
            this.convertSwimlanes(jpdl3Root, jpdl4Root);
            this.convertActions(jpdl3Root, null, null);
            this.convertNodes(jpdl3Root, jpdl4Root);
            this.convertEvents(jpdl3Root, jpdl4Root);
            this.convertExceptionHandlers(jpdl3Root, jpdl4Root);
            this.convertTasks(jpdl3Root, jpdl4Root);
            this.resolveTransitionDestinations();
            this.verifySwimlaneAssignments();
        }
        catch (Exception e) {
            log.error((Object)"couldn't parse process definition", (Throwable)e);
            this.addProblem(new Problem(2, "couldn't parse process definition", e));
        }
        if (Problem.containsProblemsOfLevel(this.problems, 2)) {
            throw new ConvertException(this.problems);
        }
        if (this.problems != null) {
            for (Problem problem : this.problems) {
                log.warn((Object)("process parse warning: " + problem.getDescription()));
            }
        }
        return this.jpdl4Document;
    }

    protected Element parseProcessDefinitionAttributes(Element root) {
        Element element = this.jpdl4Document.addElement("process", "http://jbpm.org/4.3/jpdl");
        element.addAttribute("name", root.attributeValue("name"));
        return element;
    }

    protected void convertSwimlanes(Element jpdl3Element, Element jpdl4Element) {
        Iterator iter = jpdl3Element.elementIterator("swimlane");
        while (iter.hasNext()) {
            Element swimlaneElement = (Element)iter.next();
            String swimlaneName = swimlaneElement.attributeValue("name");
            if (swimlaneName == null) {
                this.addWarning("there's a swimlane without a name");
                continue;
            }
            Element swimlane4 = jpdl4Element.addElement("swimlane");
            swimlane4.addAttribute("name", swimlaneName);
            Element assignmentElement = swimlaneElement.element("assignment");
            this.swimlanesCollection.put(swimlaneName, swimlane4);
            if (assignmentElement == null) continue;
            if (assignmentElement.attribute("actor-id") != null) {
                swimlane4.addAttribute("assignee", assignmentElement.attributeValue("actor-id"));
            }
            if (assignmentElement.attribute("pooled-actors") == null) continue;
            swimlane4.addAttribute("candidate-users", assignmentElement.attributeValue("pooled-actors"));
        }
    }

    public void convertActions(Element jpdl3Element, Element jpdl4Element, String eventType) {
        Iterator nodeElementIter = jpdl3Element.elementIterator();
        while (nodeElementIter.hasNext()) {
            Element actionElement = (Element)nodeElementIter.next();
            String actionName = actionElement.getName();
            if ("cancel-timer".equalsIgnoreCase(actionName) || "mail".equalsIgnoreCase(actionName)) {
                this.addWarning("Unsupported " + actionName + " conversion on Element : " + actionElement.asXML());
            }
            if (!ActionConverterTypes.hasActionName(actionName)) continue;
            this.createAction(actionElement, jpdl4Element);
        }
    }

    public void convertNodes(Element jpdl3Element, Element jpdl4Element) {
        Iterator nodeElementIter = jpdl3Element.elementIterator();
        while (nodeElementIter.hasNext()) {
            Element nodeElement = (Element)nodeElementIter.next();
            String nodeName = nodeElement.getName();
            Class<? extends Node> nodeType = NodeConverterTypes.getNodeType(nodeName);
            if (nodeType == null) continue;
            Node node = null;
            try {
                node = nodeType.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("couldn't instantiate node '" + nodeName + "', of type '" + nodeType.getName() + "'"), (Throwable)e);
                continue;
            }
            List starts = jpdl4Element.elements("start-state");
            if (node instanceof StartState && !starts.isEmpty()) {
                this.addError("max one start-state allowed in a process");
                continue;
            }
            if (node instanceof TaskNode) {
                this.convertTasks(nodeElement, jpdl4Element);
                continue;
            }
            node.setNodeElement(nodeElement);
            Element actionElement = nodeElement.element("action");
            if (nodeName.equals("node") && actionElement == null) {
                this.addError("Could not convert a node without action element:" + nodeElement.asXML());
                return;
            }
            node.createConvertedElement(jpdl4Element);
            this.convertNode(nodeElement, node.getConvertedElement());
            node.read(this);
        }
    }

    public void convertEvents(Element jpdl3Element, Element jpdl4Element) {
        Iterator iter = jpdl3Element.elementIterator("event");
        while (iter.hasNext()) {
            Element eventElement = (Element)iter.next();
            Element onElement = jpdl4Element.addElement("on");
            String type = eventElement.attributeValue("type");
            onElement.addAttribute("event", type);
            this.convertActions(eventElement, onElement, type);
        }
    }

    public void convertTasks(Element jpdl3Element, Element jpdl4Element) {
        List elements = jpdl3Element.elements("task");
        Element[] tasks = elements.toArray(new Element[0]);
        if (tasks != null && tasks.length > 0) {
            for (int i = 0; i < tasks.length; ++i) {
                Element tmpTask = tasks[i];
                Element task4 = this.convertTask(tmpTask, jpdl4Element);
                if (i == 0) {
                    task4.addAttribute("name", jpdl3Element.attributeValue("name"));
                } else {
                    task4.addAttribute("name", tmpTask.attributeValue("name"));
                }
                if (i + 1 < tasks.length) {
                    Element newTransistion = task4.addElement("transition");
                    String to = tasks[i + 1].attributeValue("name");
                    newTransistion.addAttribute("name", to);
                    newTransistion.addAttribute("to", to);
                    continue;
                }
                List transitions = jpdl3Element.elements("transition");
                for (Element trans : transitions) {
                    Element transElement = task4.addElement("transition");
                    String transName = trans.attributeValue("name") == null ? trans.attributeValue("to") : trans.attributeValue("name");
                    transElement.addAttribute("name", transName);
                    transElement.addAttribute("to", trans.attributeValue("to"));
                }
            }
        }
    }

    public Element convertTask(Element taskElement, Element jpdlElement) {
        Element taskControllerElement;
        String signallingText;
        String blockingText;
        String priorityText;
        String condition;
        String description;
        Element task4 = jpdlElement.addElement("task");
        String name = taskElement.attributeValue("name");
        if (name != null) {
            task4.attributeValue("name", name);
        }
        if ((description = taskElement.elementTextTrim("description")) != null) {
            task4.addComment(description);
        }
        if ((condition = taskElement.elementTextTrim("condition")) == null) {
            condition = taskElement.attributeValue("condition");
        }
        if (condition == null) {
            this.addWarning("Unsupported condition attribute converstion for task : " + taskElement.asXML());
        }
        String swimlaneName = taskElement.attributeValue("swimlane");
        Element assignmentElement = taskElement.element("assignment");
        if (swimlaneName != null) {
            Element swimLane = this.swimlanesCollection.get(swimlaneName);
            if (swimLane == null) {
                this.addWarning("task references unknown swimlane '" + swimlaneName + "':" + taskElement.asXML());
            } else {
                task4.addAttribute("swimlane", swimlaneName);
            }
        } else if (assignmentElement != null) {
            if (assignmentElement.attribute("actor-id") != null || assignmentElement.attribute("pooled-actors") != null) {
                String actorid = assignmentElement.attributeValue("actor-id");
                String pooledactors = assignmentElement.attributeValue("pooled-actors");
                if (actorid != null) {
                    task4.addAttribute("assignee", actorid);
                }
                if (pooledactors != null) {
                    task4.addAttribute("candidate-groups", pooledactors);
                }
            } else {
                this.convertAssignmentDelegation(assignmentElement, task4);
            }
        } else {
            log.info((Object)("process xml information: no swimlane or assignment specified for task '" + taskElement.asXML() + "'"));
        }
        this.convertEvents(taskElement, task4);
        String notificationsText = taskElement.attributeValue("notify");
        if (notificationsText != null && ("true".equalsIgnoreCase(notificationsText) || "on".equalsIgnoreCase(notificationsText) || "yes".equalsIgnoreCase(notificationsText))) {
            Element notify = task4.addElement("notification");
            notify.addAttribute("continue", "sync");
        }
        this.convertTaskReminders(taskElement, task4);
        this.convertTaskTimers(taskElement, task4);
        this.convertExceptionHandlers(taskElement, task4);
        String duedateText = taskElement.attributeValue("duedate");
        if (duedateText != null) {
            this.addWarning("Unsupported duedateDate attribute converstion for task : " + taskElement.asXML());
        }
        if ((priorityText = taskElement.attributeValue("priority")) != null) {
            this.addWarning("Unsupported priorityText attribute converstion for task : " + taskElement.asXML());
        }
        if ((blockingText = taskElement.attributeValue("blocking")) != null) {
            this.addWarning("Unsupported blocking attribute converstion for task : " + taskElement.asXML());
        }
        if ((signallingText = taskElement.attributeValue("signalling")) != null) {
            this.addWarning("Unsupported signallingText attribute converstion for task : " + taskElement.asXML());
        }
        if ((taskControllerElement = taskElement.element("controller")) != null) {
            this.addWarning("Unsupported controller converstion for task : " + taskElement.asXML());
        }
        return task4;
    }

    protected void convertAssignmentDelegation(Element jpdl3AssignmentElement, Element jpdl4Task) {
        String expression = jpdl3AssignmentElement.attributeValue("expression");
        String actorId = jpdl3AssignmentElement.attributeValue("actor-id");
        String pooledActors = jpdl3AssignmentElement.attributeValue("pooled-actors");
        if (expression == null) {
            if (actorId != null || pooledActors != null) {
                jpdl4Task.addComment("Please Update the AssignmentHandler and implement org.jbpm.api.task.AssignmentHandler to create your own AssignmentHandler.");
                Element assignmentHandler = jpdl4Task.addElement("assignment-handler");
                assignmentHandler.addAttribute("class", "org.jbpm.taskmgmt.assignment.ActorAssignmentHandler");
                String configuration = "";
                if (actorId != null) {
                    configuration = configuration + "<actorId>" + actorId + "</actorId>";
                }
                if (pooledActors != null) {
                    configuration = configuration + "<pooledActors>" + pooledActors + "</pooledActors>";
                }
            } else {
                String claz = jpdl3AssignmentElement.attributeValue("class");
                Element assignmentHandler = jpdl4Task.addElement("assignment-handler");
                assignmentHandler.addAttribute("class", claz);
            }
        }
    }

    public List<VariableAccess> convertVariableAccesses(Element element) {
        ArrayList<VariableAccess> variableAccesses = new ArrayList<VariableAccess>();
        Iterator iter = element.elementIterator("variable");
        while (iter.hasNext()) {
            Element variableElement = (Element)iter.next();
            String variableName = variableElement.attributeValue("name");
            if (variableName == null) {
                this.addProblem(new Problem(3, "the name attribute of a variable element is required: " + variableElement.asXML()));
            }
            String access = variableElement.attributeValue("access", "read,write");
            String mappedName = variableElement.attributeValue("mapped-name");
            variableAccesses.add(new VariableAccess(variableName, access, mappedName));
        }
        return variableAccesses;
    }

    public void convertNode(Element jpdl3Element, Element jpdl4Element) {
        String asyncText;
        String description;
        String name = jpdl3Element.attributeValue("name");
        if (name != null) {
            jpdl4Element.addAttribute("name", name);
            this.nodeCollection.put(name, jpdl4Element);
        }
        if ((description = jpdl3Element.elementTextTrim("description")) != null) {
            jpdl4Element.addComment(description);
        }
        if ("true".equalsIgnoreCase(asyncText = jpdl3Element.attributeValue("async"))) {
            jpdl4Element.addAttribute("continue", "async");
        } else if ("exclusive".equalsIgnoreCase(asyncText)) {
            jpdl4Element.addAttribute("continue", "exclusive");
        }
        this.convertNodeTimers(jpdl3Element, jpdl4Element);
        this.convertEvents(jpdl3Element, jpdl4Element);
        this.convertExceptionHandlers(jpdl3Element, jpdl4Element);
        this.addUnresolvedTransitionDestination(jpdl3Element, jpdl4Element);
    }

    protected void convertNodeTimers(Element nodeElement, Element jpdl4Element) {
        Iterator iter = nodeElement.elementIterator("timer");
        while (iter.hasNext()) {
            Element timerElement = (Element)iter.next();
            this.convertNodeTimer(timerElement, jpdl4Element);
        }
    }

    protected void convertNodeTimer(Element timerElement, Element jpdl4Element) {
        String name = timerElement.attributeValue("name", timerElement.getName());
        if (name == null) {
            name = this.generateTimerName();
        }
        CreateTimerAction createTimerAction = new CreateTimerAction();
        Element onElement = jpdl4Element.addElement("on");
        onElement.addAttribute("event", "timeout");
        createTimerAction.createConvertedElement(timerElement, onElement);
        createTimerAction.read(timerElement, this);
    }

    private String generateTimerName() {
        return "timer-" + this.timerNumber++;
    }

    protected void convertTaskTimers(Element taskElement, Element jdpl4Element) {
        Iterator iter = taskElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (!"timer".equals(element.getName())) continue;
            this.convertTaskTimer(element, jdpl4Element);
        }
    }

    protected void convertTaskReminders(Element taskElement, Element jdpl4Element) {
        Iterator iter = taskElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (!"reminder".equals(element.getName())) continue;
            this.convertTaskTimer(element, jdpl4Element);
        }
    }

    protected void convertTaskTimer(Element timerElement, Element jpdl4Element) {
        if ("timer".equals(timerElement.getName())) {
            String name = timerElement.attributeValue("name", timerElement.getName());
            if (name == null) {
                name = this.generateTimerName();
            }
            Element timer = jpdl4Element.addElement("timer");
            String dueDate = timerElement.attributeValue("duedate");
            if (dueDate == null) {
                this.addWarning("no duedate specified in create timer action '" + timerElement.asXML() + "'");
            } else {
                timer.addAttribute("duedate", dueDate);
            }
            String repeat = timerElement.attributeValue("repeat");
            if ("true".equalsIgnoreCase(repeat) || "yes".equalsIgnoreCase(repeat)) {
                repeat = dueDate;
            }
            timer.addAttribute("repeat", repeat);
            String transitionName = timerElement.attributeValue("transition");
            if (transitionName != null && repeat != null) {
                repeat = null;
                this.addProblem(new Problem(3, "ignoring repeat on timer with transition " + timerElement.asXML()));
            }
            this.convertSingleAction(timerElement, timer);
        } else {
            Element reminder = jpdl4Element.addElement("reminder");
            String dueDate = timerElement.attributeValue("duedate");
            if (dueDate == null) {
                this.addWarning("no duedate specified in reminder element '" + timerElement.asXML() + "'");
            } else {
                reminder.addAttribute("duedate", dueDate);
            }
            String repeat = timerElement.attributeValue("repeat");
            if ("true".equalsIgnoreCase(repeat) || "yes".equalsIgnoreCase(repeat)) {
                repeat = dueDate;
            }
            reminder.addAttribute("repeat", repeat);
        }
    }

    public Element convertSingleAction(Element jpdl3NodeElement, Element jpdl4Element) {
        Element jpdl4Action = null;
        Iterator iter = jpdl3NodeElement.elementIterator();
        while (iter.hasNext()) {
            Element candidate = (Element)iter.next();
            if (!ActionConverterTypes.hasActionName(candidate.getName())) continue;
            jpdl4Action = this.createAction(candidate, jpdl4Element);
        }
        return jpdl4Action;
    }

    public Element createAction(Element actionElement, Element jpdl4Element) {
        Action action = null;
        String actionName = actionElement.getName();
        Class<? extends Action> actionType = ActionConverterTypes.getActionType(actionName);
        try {
            action = actionType.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("couldn't instantiate action '" + actionName + "', of type '" + actionType.getName() + "'"), (Throwable)e);
        }
        Element action4 = action.createConvertedElement(actionElement, jpdl4Element);
        action.read(actionElement, this);
        return action4;
    }

    protected void convertExceptionHandlers(Element jpdl3Element, Element jpdl4Element) {
        Iterator iter = jpdl3Element.elementIterator("exception-handler");
        if (iter.hasNext()) {
            this.addWarning("Unsupported exception handler conversion for element : <" + jpdl3Element.getName() + " name=\"" + jpdl3Element.attributeValue("name") + "\"/>");
        }
    }

    public void addUnresolvedTransitionDestination(Element nodeElement, Element jpdl4Element) {
        this.unresolvedTransitionDestinations.add(new Object[]{nodeElement, jpdl4Element});
    }

    public void resolveTransitionDestinations() {
        for (Object[] unresolvedTransition : this.unresolvedTransitionDestinations) {
            Element nodeElement = (Element)unresolvedTransition[0];
            Element jpdl4Element = (Element)unresolvedTransition[1];
            this.resolveTransitionDestinations(nodeElement.elements("transition"), jpdl4Element);
        }
    }

    public void resolveTransitionDestinations(List<?> transitionElements, Element jpdl4Element) {
        for (Object transitionElement : transitionElements) {
            this.resolveTransitionDestination((Element)transitionElement, jpdl4Element);
        }
    }

    public void resolveTransitionDestination(Element transitionElement, Element jpdl4Element) {
        String toName;
        Element conditionElement;
        String condition;
        Element transition4 = jpdl4Element.addElement("transition");
        transition4.addAttribute("name", transitionElement.attributeValue("name"));
        if (transitionElement.elementTextTrim("description") != null) {
            transition4.addComment(transitionElement.elementTextTrim("description"));
        }
        if ((condition = transitionElement.attributeValue("condition")) == null && (conditionElement = transitionElement.element("condition")) != null && ((condition = conditionElement.getTextTrim()) == null || condition.length() == 0)) {
            condition = conditionElement.attributeValue("expression");
        }
        if (condition != null && condition.length() > 0) {
            Element condition4 = transition4.addElement("condition");
            condition4.addAttribute("expr", condition);
        }
        if ((toName = transitionElement.attributeValue("to")) == null) {
            this.addWarning("node '" + transitionElement.getPath() + "' has a transition without a 'to'-attribute to specify its destinationNode");
        } else {
            Element to = this.findNode(toName);
            if (to == null) {
                this.addWarning("transition to='" + toName + "' on node '" + transitionElement.getName() + "' cannot be resolved");
            }
            transition4.addAttribute("to", toName);
        }
        this.convertActions(transitionElement, transition4, "");
        this.convertExceptionHandlers(transitionElement, transition4);
    }

    public void addUnresolvedActionReference(Element actionElemen) {
    }

    public void resolveActionReferences() {
    }

    public void verifySwimlaneAssignments() {
    }

    public void createMailDelegation(String template, String actors, String to, String subject, String text) {
    }

    public String getProperty(String property, Element element) {
        Element propertyElement;
        String value = element.attributeValue(property);
        if (value == null && (propertyElement = element.element(property)) != null) {
            value = propertyElement.getText();
        }
        return value;
    }

    private Element findNode(String name) {
        return this.nodeCollection.get(name);
    }

    public Document getJpdl4Document() {
        return this.jpdl4Document;
    }
}

