/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.jpdl.internal.convert.ConverterContext;
import org.jbpm.jpdl.internal.convert.Jpdl3Converter;
import org.jbpm.jpdl.internal.convert.exception.IllegalCommandException;
import org.jbpm.jpdl.internal.convert.problem.Problem;

public class JpdlConverterTool {
    public static void main(String[] args) {
        block10: {
            JpdlConverterTool jpdlConverterTool = new JpdlConverterTool();
            ConverterContext context = null;
            try {
                context = jpdlConverterTool.parseParam(args);
                jpdlConverterTool.validate(context);
            }
            catch (IllegalCommandException e) {
                System.err.println(e.getMessage());
                System.err.println(jpdlConverterTool.getUsage());
                return;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return;
            }
            boolean verbose = false;
            if (context.get("verbose") != null) {
                verbose = true;
            }
            Jpdl3Converter jpdlConverter = new Jpdl3Converter((URL)context.get("processFileURL"));
            try {
                if (verbose) {
                    System.out.println("Loading process file from URL [" + context.get("processFileURL") + "]...");
                }
                Document jpdl4Doc = jpdlConverter.readAndConvert();
                if (verbose) {
                    System.out.println("Converting the process file to jPDL4 version....");
                }
                String outputFilePath = (String)context.get("outputFile");
                File outputFile = new File(outputFilePath);
                FileWriter fileWriter = new FileWriter(outputFile);
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((Writer)fileWriter, format);
                writer.write(jpdl4Doc);
                writer.close();
                if (!verbose) break block10;
                System.out.println("Generating converted file to:" + (outputFile.isAbsolute() ? outputFile.getAbsolutePath() : outputFile.getName()));
            }
            catch (Exception e) {
                for (Problem problem : jpdlConverter.problems) {
                    if (problem.getLevel() == 3) {
                        System.err.println(problem);
                    }
                    if (problem.getLevel() >= 3) continue;
                    System.err.println(problem);
                    if (problem.getException() == null || context.get("verbose") == null) continue;
                    problem.getException().printStackTrace(System.err);
                    System.err.println();
                }
            }
        }
    }

    public ConverterContext parseParam(String[] args) throws IllegalCommandException {
        ConverterContext context = new ConverterContext();
        if (args.length == 0) {
            throw new IllegalCommandException("No file for conversion is supplied");
        }
        for (int i = 0; i < args.length; ++i) {
            String token = args[i];
            if ("-v".equalsIgnoreCase(token) || "-verbose".equalsIgnoreCase(token)) {
                context.put("verbose", "verbose");
                continue;
            }
            if ("-o".equalsIgnoreCase(token) || "-output".equalsIgnoreCase(token)) {
                int j;
                if ((j = ++i) < args.length) {
                    String outputFile = args[j];
                    context.put("outputFile", args[j]);
                    continue;
                }
                throw new IllegalCommandException("Missing output file name");
            }
            if (token.startsWith("-")) {
                throw new IllegalCommandException("Unknow flag [" + token + "]");
            }
            if (context.get("processFile") == null) {
                context.put("processFile", token);
                continue;
            }
            throw new IllegalCommandException("Duplicate input process file");
        }
        if (context.get("processFile") == null) {
            throw new IllegalCommandException("No input process file defined");
        }
        return context;
    }

    public void validate(ConverterContext context) throws Exception {
        String processFile = (String)context.get("processFile");
        URL processURL = this.getFileURL(processFile);
        if (processURL == null) {
            throw new IllegalCommandException("Failed to load the process file [" + processFile + "]");
        }
        context.put("processFileURL", processURL);
        if (context.get("outputFile") == null) {
            String fileName;
            File tmpFile = new File(processURL.getFile());
            String baseName = fileName = tmpFile.getName();
            int index = fileName.lastIndexOf(".");
            baseName = index > -1 ? fileName.substring(0, index) : fileName;
            String outputFileName = baseName + ".converted.jpdl.xml";
            File outFile = new File(".", outputFileName);
            context.put("outputFile", outFile.getAbsolutePath());
        } else {
            String outputFile = (String)context.get("outputFile");
            File file = new File(outputFile);
            if (file.isAbsolute()) {
                if (!file.getParentFile().exists()) {
                    throw new IllegalCommandException("Output directory [" + file.getParent() + "] does not exist");
                }
            } else {
                file = new File(".", outputFile);
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            context.put("outputFile", file.getAbsolutePath());
        }
    }

    public URL getFileURL(String fileName) {
        try {
            URL url = new URL(fileName);
            return url;
        }
        catch (MalformedURLException e1) {
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            File tmpFile = new File(".", fileName);
            if (file.exists()) {
                try {
                    return tmpFile.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public String getUsage() {
        return "Usage : java org.jbpm.jpdl.internal.convert.JpdlConverterTool <file>\r\n        java org.jbpm.jpdl.internal.convert.JpdlConverterTool -v -o <outputfile> <file>";
    }
}

