/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert.action;

import org.dom4j.Element;
import org.jbpm.jpdl.internal.convert.Jpdl3Converter;

public class Action {
    protected Element convertedElement = null;
    protected boolean isPropagationAllowed = true;
    protected boolean isAsync = false;
    protected boolean isAsyncExclusive = false;

    public Element createConvertedElement(Element actionElement, Element jpdl4Doc) {
        String expression = actionElement.attributeValue("expression");
        this.convertedElement = expression != null ? jpdl4Doc.addElement("script") : (actionElement.attributeValue("class") != null ? jpdl4Doc.addElement("java") : jpdl4Doc.addElement("custom"));
        return this.convertedElement;
    }

    public void read(Element actionElement, Jpdl3Converter jpdlReader) {
        String asyncText;
        String expression = actionElement.attributeValue("expression");
        if (expression != null) {
            this.convertedElement.addAttribute("expr", expression);
            this.convertedElement.addAttribute("lang", "juel");
        } else if (actionElement.attribute("ref-name") != null) {
            jpdlReader.addWarning("Unsupported ref-name attribute conversion in element " + actionElement.asXML());
        } else if (actionElement.attribute("class") != null) {
            this.convertedElement.addAttribute("class", actionElement.attributeValue("class"));
            this.convertedElement.addAttribute("method", "execute");
        } else {
            jpdlReader.addWarning("action does not have class nor ref-name attribute, generated the default node <custom>  " + actionElement.asXML());
        }
        String acceptPropagatedEvents = actionElement.attributeValue("accept-propagated-events");
        if ("false".equalsIgnoreCase(acceptPropagatedEvents) || "no".equalsIgnoreCase(acceptPropagatedEvents) || "off".equalsIgnoreCase(acceptPropagatedEvents)) {
            this.isPropagationAllowed = false;
        }
        if ("true".equalsIgnoreCase(asyncText = actionElement.attributeValue("async"))) {
            this.convertedElement.addAttribute("continue", "async");
        } else if ("exclusive".equalsIgnoreCase(asyncText)) {
            this.convertedElement.addAttribute("continue", "exclusive");
        }
    }
}

