/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert.node;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.jpdl.internal.convert.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConverterTypes {
    private static final Log log = LogFactory.getLog(NodeConverterTypes.class);
    private static SAXReader reader = new SAXReader();
    static Map<String, Class<? extends Node>> nodeTypes = NodeConverterTypes.initialiseNodeTypes();
    static Map<Class<? extends Node>, String> nodeNames = NodeConverterTypes.createInverseMapping(nodeTypes);

    public static Set<String> getNodeTypes() {
        return nodeTypes.keySet();
    }

    public static Set<Class<? extends Node>> getNodeNames() {
        return nodeNames.keySet();
    }

    public static Class<? extends Node> getNodeType(String name) {
        return nodeTypes.get(name);
    }

    public static String getNodeName(Class<? extends Node> type) {
        return nodeNames.get(type);
    }

    static Map<String, Class<? extends Node>> initialiseNodeTypes() {
        HashMap<String, Class<? extends Node>> types = new HashMap<String, Class<? extends Node>>();
        InputStream nodeTypesStream = NodeConverterTypes.class.getClassLoader().getResourceAsStream("node.converter.types.xml");
        Element nodeTypesElement = null;
        try {
            nodeTypesElement = reader.read(nodeTypesStream).getRootElement();
        }
        catch (DocumentException e1) {
            log.error((Object)"Failed to parse the node.converter.types.xml", (Throwable)e1);
        }
        Iterator nodeTypeIterator = nodeTypesElement.elementIterator("node-type");
        while (nodeTypeIterator.hasNext()) {
            Element nodeTypeElement = (Element)nodeTypeIterator.next();
            String elementTag = nodeTypeElement.attributeValue("element");
            String className = nodeTypeElement.attributeValue("class");
            try {
                Class<?> nodeClass = Class.forName(className);
                types.put(elementTag, nodeClass.asSubclass(Node.class));
            }
            catch (Exception e) {
                if ("org.jboss.seam.jbpm.Page".equals(className) || !log.isDebugEnabled()) continue;
                log.debug((Object)("node '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded"));
            }
        }
        return types;
    }

    public static <K, V> Map<V, K> createInverseMapping(Map<K, V> map) {
        HashMap<V, K> inverse = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverse.put(entry.getValue(), entry.getKey());
        }
        return inverse;
    }
}

