/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert.action;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.jpdl.internal.convert.action.Action;
import org.jbpm.jpdl.internal.convert.node.NodeConverterTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConverterTypes {
    private static SAXReader reader = new SAXReader();
    static final Log log = LogFactory.getLog(ActionConverterTypes.class);
    static Map<String, Class<? extends Action>> actionTypes = ActionConverterTypes.initialiseActionTypes();
    static Map<Class<? extends Action>, String> actionNames = NodeConverterTypes.createInverseMapping(actionTypes);

    public static Set<Class<? extends Action>> getActionTypes() {
        return actionNames.keySet();
    }

    public static Set<String> getActionNames() {
        return actionTypes.keySet();
    }

    public static Class<? extends Action> getActionType(String name) {
        return actionTypes.get(name);
    }

    public static String getActionName(Class<? extends Action> type) {
        return actionNames.get(type);
    }

    public static boolean hasActionName(String name) {
        return actionTypes.containsKey(name);
    }

    static Map<String, Class<? extends Action>> initialiseActionTypes() {
        HashMap<String, Class<? extends Action>> types = new HashMap<String, Class<? extends Action>>();
        InputStream actionTypesStream = ActionConverterTypes.class.getClassLoader().getResourceAsStream("action.converter.types.xml");
        Element actionTypesElement = null;
        try {
            actionTypesElement = reader.read(actionTypesStream).getRootElement();
        }
        catch (DocumentException e1) {
            log.error((Object)"Failed to parse the action.converter.types.xml", (Throwable)e1);
        }
        Iterator actionTypeIterator = actionTypesElement.elementIterator("action-type");
        while (actionTypeIterator.hasNext()) {
            Element actionTypeElement = (Element)actionTypeIterator.next();
            String elementTag = actionTypeElement.attributeValue("element");
            String className = actionTypeElement.attributeValue("class");
            try {
                Class<?> actionClass = Class.forName(className);
                types.put(elementTag, actionClass.asSubclass(Action.class));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("action '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded"));
            }
        }
        return types;
    }
}

