/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.convert.action;

import org.dom4j.Element;
import org.jbpm.jpdl.internal.convert.Jpdl3Converter;
import org.jbpm.jpdl.internal.convert.action.Action;
import org.jbpm.jpdl.internal.convert.problem.Problem;

public class CreateTimerAction
extends Action {
    public Element createConvertedElement(Element actionElement, Element jpdl4Doc) {
        this.convertedElement = jpdl4Doc.addElement("timer");
        return this.convertedElement;
    }

    public void read(Element actionElement, Jpdl3Converter jpdlReader) {
        String transitionName;
        Element timerAction = jpdlReader.convertSingleAction(actionElement, this.convertedElement);
        String dueDate = actionElement.attributeValue("duedate");
        if (dueDate == null) {
            jpdlReader.addWarning("no duedate specified in create timer action '" + actionElement + "'");
        } else {
            this.convertedElement.addAttribute("duedate", dueDate);
        }
        String repeat = actionElement.attributeValue("repeat");
        if ("true".equalsIgnoreCase(repeat) || "yes".equalsIgnoreCase(repeat)) {
            repeat = dueDate;
        }
        if (repeat != null) {
            this.convertedElement.addAttribute("repeat", repeat);
        }
        if ((transitionName = actionElement.attributeValue("transition")) != null && repeat != null) {
            repeat = null;
            jpdlReader.addProblem(new Problem(3, "ignoring repeat on timer with transition " + actionElement.asXML()));
        }
    }
}

