/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.xpdl21;

import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.dialect.xpdl21.model.XPDLActivities;
import org.jboss.bpm.dialect.xpdl21.model.XPDLActivity;
import org.jboss.bpm.dialect.xpdl21.model.XPDLEvent;
import org.jboss.bpm.dialect.xpdl21.model.XPDLWorkflowProcess;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.ProcessBuilderFactory;

public class WorkflowProcessAdapter {
    public Process adaptWorkflowProcess(XPDLWorkflowProcess xpdlProc) {
        ProcessBuilder builder = ProcessBuilderFactory.newInstance().newProcessBuilder();
        builder.addProcess(xpdlProc.getName());
        XPDLActivities xpdlActivities = xpdlProc.getActivities();
        for (XPDLActivity xpdlActivity : xpdlActivities.getActivity()) {
            XPDLEvent xpdlEvent = xpdlActivity.getEvent();
            if (xpdlEvent != null) {
                if (xpdlEvent.getStartEvent() != null) {
                    builder.addStartEvent("Start");
                    continue;
                }
                if (xpdlEvent.getEndEvent() != null) {
                    builder.addEndEvent(xpdlActivity.getName());
                    continue;
                }
                throw new InvalidProcessException("Unsupported type: " + xpdlEvent);
            }
            throw new InvalidProcessException("Unsupported type: " + xpdlActivity);
        }
        Process proc = builder.getProcess();
        return proc;
    }
}

