/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.client;

// $Id: MessageManagerImpl.java 1984 2008-08-22 12:31:53Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.Event;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.ri.model.impl.ProcessImpl;

/**
 * The ProcessEngine sends mesages through the MessageManager. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class MessageManagerImpl extends MessageManager
{
  // provide logging
  private static final Log log = LogFactory.getLog(MessageManagerImpl.class);
  
  /**
   * Send a message to a given {@link Task} or {@link Event}
   */
  @Override
  public void sendMessage(ObjectName procID, String targetName, Message msg)
  {
    ProcessManager pm = ProcessManager.locateProcessManager();
    Process proc = pm.getProcessByID(procID);
    if (proc == null)
      throw new IllegalStateException("Cannot obtain registered process: " + procID);

    ProcessImpl procImpl = (ProcessImpl)proc;
    FlowObject target = procImpl.getFlowObject(targetName);
    if (target == null)
      throw new IllegalArgumentException("Cannot find message target: " + targetName);
    if (target instanceof MessageListener == false)
      throw new IllegalArgumentException("Message target is not a valid message receiver: " + targetName);

    log.debug("sendMessage to " + target + " => " + msg);
    MessageListener msgListener = (MessageListener)target;
    msgListener.catchMessage(msg);
  }
}