/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: AbstractElementImpl.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.jboss.bpm.model.AbstractElement;
import org.jboss.bpm.model.Process;

/**
 * The parrent of all Elements
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public abstract class AbstractElementImpl implements AbstractElement
{
  // The cached ID
  protected ObjectName id;
  
  /**
   * Get the ID of this element
   */
  public abstract ObjectName getID();
  
  /**
   * Called when the process is created
   */
  protected void create(Process proc)
  {
    // nothing to do
  }

  /**
   * Called when the process is registered
   */
  protected void register(Process proc)
  {
    // nothing to do
  }

  /**
   * Called when the process is unregistered
   */
  protected void unregister(Process proc)
  {
    // nothing to do
  }

  /**
   * Called when the process is destroyed
   */
  protected void destroy(Process proc)
  {
    // nothing to do
  }
}