/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: ActivityBuilderImpl.java 1989 2008-08-22 20:13:51Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.ActivityBuilder;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.model.Expression.ExpressionLanguage;

/**
 * The ActivityBuilder can be used to build an {@link Activity} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class ActivityBuilderImpl extends ProcessBuilderImpl implements ActivityBuilder
{
  private InputSetImpl inputSet;
  private OutputSetImpl outputSet;

  public ActivityBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject)
  {
    super(proc, flowObject);
  }

  public ActivityBuilder addInputSet()
  {
    inputSet = new InputSetImpl();
    getActivity().addInputSet(inputSet);
    return this;
  }

  public ActivityBuilder addPropertyInput(String name)
  {
    Property prop = new PropertyImpl(name, null);
    inputSet.addProperty(prop);
    return this;
  }

  public ActivityBuilder addOutputSet()
  {
    outputSet = new OutputSetImpl();
    getActivity().addOutputSet(outputSet);
    return this;
  }

  public ActivityBuilder addPropertyOutput(String name, String value)
  {
    Property prop = new PropertyImpl(name, new ExpressionImpl(value));
    outputSet.addProperty(prop);
    return this;
  }

  public ActivityBuilder addIORule(String body, ExpressionLanguage lang)
  {
    ExpressionImpl expr = new ExpressionImpl(lang, body);
    getActivity().addIORule(expr);
    return this;
  }
  
  public ActivityBuilder addProperty(String name, String value)
  {
    Property prop = new PropertyImpl(name, new ExpressionImpl(ExpressionLanguage.String, value));
    getActivity().addProperty(prop);
    return this;
  }
  
  private ActivityImpl getActivity()
  {
    if (flowObject instanceof Activity == false)
      throw new IllegalStateException("Last added flow object is not a Activity");
    return (ActivityImpl)flowObject;
  }
}