/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: AssignmentImpl.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Property;

/**
 * An Assignment, which is used in the definition of attributes for Process, Activities, Events, Gateways, and Gates.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class AssignmentImpl extends SupportingElementImpl implements Assignment
{
  private AssignTime assignTime;
  private Expression from;
  private Property to;

  public AssignmentImpl(AssignTime assignTime, Expression from, Property to)
  {
    this.assignTime = assignTime;
    this.from = from;
    this.to = to;
  }

  public AssignTime getAssignTime()
  {
    return assignTime;
  }

  public Expression getFrom()
  {
    return from;
  }

  public Property getTo()
  {
    return to;
  }
}