/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: EventBuilderImpl.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.EndEvent;
import org.jboss.bpm.model.Event;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.IntermediateEvent;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.model.EventDetail.EventDetailType;
import org.jboss.bpm.model.Signal.SignalType;

/**
 * The EventBuilder can be used to build an {@link Event} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class EventBuilderImpl extends ProcessBuilderImpl implements EventBuilder
{
  private EventDetail eventDetail;

  public EventBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject)
  {
    super(proc, flowObject);
  }

  public EventBuilder addEventDetail(EventDetailType detailType)
  {
    if (detailType == EventDetailType.Message)
    {
      eventDetail = new MessageEventDetailImpl();
      addEventDetail(getEvent(), eventDetail);
    }
    else if (detailType == EventDetailType.Timer)
    {
      throw new NotImplementedException("JBPM-1663", "EventDetail Timer");
    }
    else if (detailType == EventDetailType.Error)
    {
      throw new NotImplementedException("JBPM-1664", "EventDetail Error");
    }
    else if (detailType == EventDetailType.Cancel)
    {
      throw new NotImplementedException("JBPM-1665", "EventDetail Cancel");
    }
    else if (detailType == EventDetailType.Compensation)
    {
      throw new NotImplementedException("JBPM-1666", "EventDetail Compensation");
    }
    else if (detailType == EventDetailType.Conditional)
    {
      throw new NotImplementedException("JBPM-1667", "EventDetail Conditional");
    }
    else if (detailType == EventDetailType.Link)
    {
      throw new NotImplementedException("JBPM-1668", "EventDetail Link");
    }
    else if (detailType == EventDetailType.Signal)
    {
      eventDetail = new SignalEventDetailImpl();
      addEventDetail(getEvent(), eventDetail);
    }
    return this;
  }

  public EventBuilder addSignalRef(SignalType signalType, String message)
  {
    if (eventDetail instanceof SignalEventDetailImpl)
    {
      SignalEventDetailImpl signalEventDetail = (SignalEventDetailImpl)eventDetail;
      signalEventDetail.setSignalRef(new Signal(flowObject.getID(), signalType, message));
    }
    else
    {
      throw new IllegalStateException("Cannot add signal to: " + eventDetail);
    }
    return this;
  }

  public EventBuilder addMessageRef(String msgName)
  {
    MessageImpl message = new MessageImpl(msgName);
    if (eventDetail instanceof MessageEventDetailImpl)
    {
      MessageEventDetailImpl msgEventDetail = (MessageEventDetailImpl)eventDetail;
      msgEventDetail.setMessageRef(message);
    }
    else
    {
      throw new IllegalStateException("Cannot add message to: " + eventDetail);
    }
    return this;
  }

  private void addEventDetail(EventImpl event, EventDetail trigger)
  {
    EventDetailType detailType = trigger.getEventDetailType();
    if (event instanceof StartEvent)
    {
      StartEventImpl start = (StartEventImpl)event;
      if (start.getTrigger().size() > 0)
        throw new NotImplementedException("JBPM-1660", "StartEvent Multiple Trigger");
      
      if (detailType == EventDetailType.Message)
      {
        throw new NotImplementedException("JBPM-1657", "StartEvent Message Trigger");
      }
      else if (detailType == EventDetailType.Timer)
      {
        throw new NotImplementedException("JBPM-1658", "StartEvent Timer Trigger");
      }
      else if (detailType == EventDetailType.Conditional)
      {
        throw new NotImplementedException("JBPM-1659", "StartEvent Conditional Trigger");
      }
      else if (detailType == EventDetailType.Signal)
      {
        start.addTrigger(eventDetail);
      }
      else
      {
        throw new IllegalStateException("Unsupported start event trigger type: " + detailType);
      }
    }
    else if (event instanceof IntermediateEvent)
    {
      IntermediateEventImpl intermediate = (IntermediateEventImpl)event;
      if (intermediate.getTrigger().size() > 0)
        throw new NotImplementedException("JBPM-1682", "IntermediateEvent Multiple Trigger");
        
      if (detailType == EventDetailType.Message)
      {
        throw new NotImplementedException("JBPM-1669", "IntermediateEvent Message Trigger");
      }
      else if (detailType == EventDetailType.Timer)
      {
        throw new NotImplementedException("JBPM-1670", "IntermediateEvent Timer Trigger");
      }
      else if (detailType == EventDetailType.Error)
      {
        throw new NotImplementedException("JBPM-1671", "IntermediateEvent Error Trigger");
      }
      else if (detailType == EventDetailType.Cancel)
      {
        throw new NotImplementedException("JBPM-1672", "IntermediateEvent Cancel Trigger");
      }
      else if (detailType == EventDetailType.Compensation)
      {
        throw new NotImplementedException("JBPM-1673", "IntermediateEvent Compensation Trigger");
      }
      else if (detailType == EventDetailType.Conditional)
      {
        throw new NotImplementedException("JBPM-1674", "IntermediateEvent Conditional Trigger");
      }
      else if (detailType == EventDetailType.Link)
      {
        throw new NotImplementedException("JBPM-1675", "IntermediateEvent Link Trigger");
      }
      else if (detailType == EventDetailType.Signal)
      {
        throw new NotImplementedException("JBPM-1650", "IntermediateEvent Signal Trigger");
      }
      else
      {
        throw new IllegalStateException("Unsupported intermediate event trigger type: " + detailType);
      }
    }
    else if (event instanceof EndEvent)
    {
      EndEventImpl end = (EndEventImpl)event;
      if (end.getResult().size() > 0)
        throw new NotImplementedException("JBPM-1683", "EndEvent Multiple Result");
      
      if (detailType == EventDetailType.Message)
      {
        end.addResult(eventDetail);
      }
      else if (detailType == EventDetailType.Error)
      {
        throw new NotImplementedException("JBPM-1677", "EndEvent Error Result");
      }
      else if (detailType == EventDetailType.Cancel)
      {
        throw new NotImplementedException("JBPM-1678", "EndEvent Cancel Result");
      }
      else if (detailType == EventDetailType.Compensation)
      {
        throw new NotImplementedException("JBPM-1679", "EndEvent Compensation Result");
      }
      else if (detailType == EventDetailType.Signal)
      {
        throw new NotImplementedException("JBPM-1651", "EndEvent Signal Result");
      }
      else if (detailType == EventDetailType.Terminate)
      {
        throw new NotImplementedException("JBPM-1680", "EndEvent Terminate Result");
      }
      else
      {
        throw new IllegalStateException("Unsupported end event trigger type: " + detailType);
      }
    }
  }

  private EventImpl getEvent()
  {
    if (flowObject instanceof Event == false)
      throw new IllegalStateException("Last added flow object is not an Event: " + flowObject);
    return (EventImpl)flowObject;
  }
}