/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: FlowImpl.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.FlowObject;

/**
 * A Flow is a graphical line connecting two objects in a BPD. There are two types of Flow: Sequence Flow and Message Flow, each with their own line style. Flow is also
 * used in a generic sense (and lowercase) to describe how Tokens will traverse Sequence Flow from the Start Event to an End Event.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public abstract class FlowImpl extends SupportingElementImpl implements ConnectingObject
{
  private String name;
  private String targetName;
  private FlowObject source;
  private FlowObject target;

  public FlowImpl(String targetName)
  {
    if (targetName == null)
      throw new IllegalArgumentException("Target name cannot be null");
    
    this.targetName = targetName;
  }

  public String getName()
  {
    return name;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  public FlowObject getSourceRef()
  {
    return source;
  }

  protected void setSourceRef(FlowObject source)
  {
    this.source = source;
  }

  public FlowObject getTargetRef()
  {
    return target;
  }
  
  protected void setTargetRef(FlowObject target)
  {
    this.target = target;
  }

  public String getTargetName()
  {
    return targetName;
  }
}