/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: GateImpl.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import java.util.List;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.SequenceFlow.ConditionType;

/**
 * A {@link Gate} associated with a {@link Gateway}.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class GateImpl extends SupportingElementImpl implements Gate
{
  private SequenceFlow seqFlow;

  public GateImpl(String targetName)
  {
    seqFlow = new SequenceFlowImpl(targetName);
  }

  public GateImpl(String targetName, ConditionType type, Expression expr)
  {
    seqFlow = new SequenceFlowImpl(targetName, type, expr);
  }

  public SequenceFlow getOutgoingSequenceFlow()
  {
    return seqFlow;
  }
  
  public List<Assignment> getAssignments()
  {
    throw new NotImplementedException("JBPM-1641", "Gate Assignments");
  }
  
  public String toString()
  {
    String flowStr = seqFlow.toString();
    return "Gate" + flowStr.substring(flowStr.indexOf('['));
  }
}
