/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: InputSetImpl.java 1989 2008-08-22 20:13:51Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jboss.bpm.model.ArtifactInput;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.MutablePropertySupport;
import org.jboss.bpm.model.Property;

/**
 * An InputSet, which is used in the definition of common attributes for Activities and for attributes of a Process
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class InputSetImpl extends SupportingElementImpl implements InputSet, MutablePropertySupport
{
  private List<ArtifactInput> artInputs = new ArrayList<ArtifactInput>();
  private Map<String,Property> props = new LinkedHashMap<String,Property>();

  public List<ArtifactInput> getArtifactInputs()
  {
    return Collections.unmodifiableList(artInputs);
  }

  public void addArtifactInput(ArtifactInput artIn)
  {
    artInputs.add(artIn);
  }
  
  public Property getProperty(String name)
  {
    return props.get(name);
  }

  public Object getPropertyValue(String name)
  {
    Property prop = getProperty(name);
    return prop != null ? prop.getValue() : null;
  }

  public <T> T getPropertyValue(Class<T> clazz, String name)
  {
    Property prop = getProperty(name);
    return prop != null ? prop.getValue(clazz) : null;
  }
  
  public List<Property> getProperties()
  {
    return Collections.unmodifiableList(new ArrayList<Property>(props.values()));
  }

  public List<String> getPropertyNames()
  {
    return new ArrayList<String>(props.keySet());
  }

  public void addProperty(Property prop)
  {
    props.put(prop.getName(), prop);
  }

  @Override
  public String toString()
  {
    return "InputSet" + getPropertyNames();
  }
}
