/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: MessageBuilderImpl.java 1983 2008-08-22 11:12:51Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Property;

/**
 * A MessageBuilder can be used to build a {@link Message} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class MessageBuilderImpl implements MessageBuilder
{
  private MessageImpl message;
  
  public MessageBuilder newMessage(String name)
  {
    message = new MessageImpl(name);
    return this;
  }

  public MessageBuilder addToRef(ObjectName toRef)
  {
    message.setToRef(new EntityImpl(toRef));
    return this;
  }
  
  public MessageBuilder addFromRef(ObjectName fromRef)
  {
    message.setFromRef(new EntityImpl(fromRef));
    return this;
  }

  public MessageBuilder addProperty(String name, Object value)
  {
    Property prop = new PropertyImpl(name, new ExpressionImpl(value));
    message.addProperty(prop);
    return this;
  }

  public MessageBuilder addProperty(String name, Object value, boolean isCorrelation)
  {
    Property prop = new PropertyImpl(name, new ExpressionImpl(value), isCorrelation);
    message.addProperty(prop);
    return this;
  }

  public Message getMessage()
  {
    return message;
  }
}