/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: MessageEventDetailImpl.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Event;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageEventDetail;

/**
 * The message event detail
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class MessageEventDetailImpl extends EventDetailImpl implements MessageEventDetail
{
  private Message messageRef;
  
  public EventDetailType getEventDetailType()
  {
    return EventDetailType.Message;
  }
  
  public Message.Implementation getImplementation()
  {
    return Message.Implementation.Unspecified;
  }

  public Message getMessageRef()
  {
    return messageRef;
  }

  public void setMessageRef(Message message)
  {
    this.messageRef = message;
  }

  @Override
  protected void initialize(Event event)
  {
    super.initialize(event);
    
    ProcessImpl procImpl = (ProcessImpl)event.getProcess();
    procImpl.initializeMessageRef(messageRef);
  }
}
