/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: MessageSender.java 1984 2008-08-22 12:31:53Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.model.Entity;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.MessageBuilderFactory;
import org.jboss.bpm.model.Participant;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;

/**
 * A helper that sends messages
 * 
 * @author thomas.diesler@jboss.com
 * @since 16-Aug-2008
 */
class MessageSender
{
  private Participant fromRef;
  private Message messageRef;
  
  public MessageSender(FlowObject fromFlowObject, Message messageRef)
  {
    ObjectName procID = fromFlowObject.getProcess().getID();
    this.fromRef = new EntityImpl(procID);
    this.messageRef = messageRef;
    
    if (messageRef == null)
      throw new IllegalArgumentException("MessageRef cannot be null");
    if (fromRef == null)
      throw new IllegalArgumentException("FromRef cannot be null");
  }

  /**
   * Extract message content from the token and send the message
   * to it's recipient.
   */
  public void sendMessage(Token token)
  {
    ExecutionContext exContext = token.getExecutionContext();
    MessageBuilderFactory factory = MessageBuilderFactory.newInstance();
    MessageBuilder msgBuilder = factory.newMessageBuilder();

    Participant toRef = messageRef.getToRef();
    if (toRef == null || toRef.getEntityRef() == null)
      throw new IllegalStateException("Cannot obtain target participant");

    Entity entityRef = toRef.getEntityRef();
    ObjectName targetID = entityRef.getName();
    msgBuilder.newMessage(messageRef.getName());
    msgBuilder.addToRef(targetID);

    // Copy the properties from the execution context
    // to the send message
    for (Property auxProp : messageRef.getProperties())
    {
      String key = auxProp.getName();
      Object value = exContext.getAttachment(key);
      if (value == null)
        throw new IllegalStateException("Cannot obtain property: " + key);

      msgBuilder.addProperty(key, value);
    }
    MessageImpl msg = (MessageImpl)msgBuilder.getMessage();
    msg.setFromRef(fromRef);

    MessageManager mm = MessageManager.locateMessageManager();
    mm.sendMessage(msg);
  }
}