/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: SendTaskImpl.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $


import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SendTask;
import org.jboss.bpm.model.Message.Implementation;
import org.jboss.bpm.runtime.Token;

/**
 * Task that corresponds to the TaskType.None
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class SendTaskImpl extends TaskImpl implements SendTask
{
  // A Web service is the default technology
  private Implementation implementation = Implementation.WebService;
  private Message messageRef;

  public SendTaskImpl(String name)
  {
    super(name);
  }

  @Override
  public TaskType getTaskType()
  {
    return TaskType.Send;
  }

  public Message.Implementation getImplementation()
  {
    return implementation;
  }

  public Message getMessageRef()
  {
    return messageRef;
  }

  public void setMessageRef(Message message)
  {
    this.messageRef = message;
  }

  @Override
  protected void defaultExecution(Token token)
  {
    super.defaultExecution(token);
    
    MessageSender messageSender = new MessageSender(this, messageRef);
    messageSender.sendMessage(token);
  }

  @Override
  protected void create(Process proc)
  {
    super.create(proc);

    if (messageRef == null)
      throw new InvalidProcessException("A Message for the MessageRef attribute MUST be entered");

    ProcessImpl procImpl = (ProcessImpl)proc;
    procImpl.initializeMessageRef(messageRef);
    
    if (messageRef.getToRef() == null)
      throw new IllegalArgumentException("Message targetID cannot be null for: " + this);
  }
}