/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import java.util.List;

import org.jboss.bpm.model.Artifact;
import org.jboss.bpm.model.Property;

//$Id: DataObject.java 1929 2008-08-19 10:48:17Z thomas.diesler@jboss.com $


/**
 * DataObject, which extends common Artifact
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface DataObject extends Artifact
{
  /**
   * Name is an attribute that is text description of the object.
   */
  String getName();
  
  /**
   * State is an optional attribute that indicates the impact the Process has had on the Data
   * Object. Multiple Data Objects with the same name MAY share the same state within one Process.
   */
  String getState();
  
  /**
   * Modeler-defined Properties MAY be added to a Data Object. The fully delineated name of these 
   * properties are “<process name>.<task name>.<property name>” 
   * (e.g., “Add Customer.Review Credit Report.Score”).
   */
  List<Property> getProperties();
}
