/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import org.jboss.bpm.model.ExclusiveGateway;


//$Id: ExclusiveGatewayEventBased.java 1929 2008-08-19 10:48:17Z thomas.diesler@jboss.com $

/**
 * The inclusion of Event-Based Exclusive Gateways is the result of recent developments in the handling of distributed
 * systems (e.g., with pi-calculus) and was derived from the BPEL4WS pick. On the input side, their behavior is the same as
 * a Data-Based Exclusive Gateway (see “Data-Based” on page 73). On the output side, the basic idea is that this Decision
 * represents a branching point in the process where the alternatives are based on events that occurs at that point in the
 * Process, rather than the evaluation of expressions using process data. A specific event, usually the receipt of a message,
 * determines which of the paths will be taken. For example, if a company is waiting for a response from a customer, they
 * will perform one set of activities if the customer responds “Yes” and another set of activities if the customer responds
 * “No.” The customer’s response determines which path is taken. The identity of the Message determines which path is taken. 
 * That is, the “Yes” Message and the “No” message are different messages—they are not the same message with different values 
 * within a property of the Message. The receipt of the message can be modeled with a Task of TaskType Receive or an 
 * Intermediate Event with a Message Trigger. In addition to Messages, other Triggers for Intermediate Events can be used, such as Timers.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ExclusiveGatewayEventBased extends ExclusiveGateway
{
  /**
   * Event-Based Gateways can be defined as the instantiation mechanism for the
   * Process with the Instantiate attribute. This attribute MAY be set to true if the
   * Gateway is the first element after the Start Event or a starting Gateway if there is
   * no Start Event (i.e., there are no incoming Sequence Flow).
   */
  boolean isInstantiate();

}