/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.runtime;

//$Id: DelegatingToken.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Activity;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;

/**
 * A {@link Token} that includes properties from the current {@link Activity}
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 15-Aug-2008
 */
public class DelegatingToken implements MutableToken
{
  private MutableToken delegateToken;
  private ExecutionContext delegateContext;

  public DelegatingToken(MutableToken token)
  {
    this.delegateToken = token;
    
    FlowObject targetRef = token.getFlow().getTargetRef();
    ExecutionContext exContext = token.getExecutionContext();
    this.delegateContext = new DelegatingExecutionContext(targetRef, exContext);
  }

  public ExecutionContext getExecutionContext()
  {
    return delegateContext;
  }

  public Token copyToken()
  {
    return delegateToken.copyToken();
  }

  public SequenceFlow getFlow()
  {
    return delegateToken.getFlow();
  }

  public InputSet getInputSet()
  {
    return delegateToken.getInputSet();
  }

  public OutputSet getOutputSet()
  {
    return delegateToken.getOutputSet();
  }

  public String getTokenID()
  {
    return delegateToken.getTokenID();
  }

  public TokenStatus getTokenStatus()
  {
    return delegateToken.getTokenStatus();
  }

  public void mergeToken(Token token)
  {
    delegateToken.mergeToken(token);
  }

  public void setFlow(SequenceFlow flow)
  {
    delegateToken.setFlow(flow);
  }

  public void setTokenStatus(TokenStatus status)
  {
    delegateToken.setTokenStatus(status);
  }

  public void setInputSet(InputSet inputSet)
  {
    delegateToken.setInputSet(inputSet);
  }

  public void setOutputSet(OutputSet outputSet)
  {
    delegateToken.setOutputSet(outputSet);
  }
  
  public String toString()
  {
    FlowObject fo = getFlow().getTargetRef();
    return "[fo=" + fo + ",ctx=" + getExecutionContext() + "]";
  }
}