/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.client;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.BPMException;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.ProcessTimeoutException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.ri.model.impl.ExpressionEvaluator;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.RuntimeProcessImpl;
import org.jboss.bpm.ri.model.impl.SequenceFlowImpl;
import org.jboss.bpm.ri.runtime.DelegatingToken;
import org.jboss.bpm.ri.runtime.MutableToken;
import org.jboss.bpm.ri.runtime.RuntimeProcess;
import org.jboss.bpm.ri.runtime.TokenImpl;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

public class ExecutionManagerImpl
extends ExecutionManager {
    private static final Log log = LogFactory.getLog(ExecutionManagerImpl.class);
    private Map<ObjectName, RuntimeProcess> runtimeProcesses = new HashMap<ObjectName, RuntimeProcess>();

    public void startProcess(Process proc, Attachments att) {
        this.startProcessPrepare(proc);
        StartEvent start = this.getNoneStartEvent(proc);
        if (start != null) {
            if (proc.getProcessStatus() == Process.ProcessStatus.Active) {
                throw new IllegalStateException("Cannot start an already active process");
            }
            this.startProcessInternal(start, att);
        }
    }

    public void startProcess(StartEvent start, Attachments att) {
        this.startProcessPrepare(start.getProcess());
        this.startProcessInternal(start, att);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startProcessInternal(StartEvent start, Attachments att) {
        Process proc = start.getProcess();
        RuntimeProcess rtProc = this.getRuntimeProcess(proc, false);
        boolean startProcessThread = rtProc == null;
        TokenImpl initialToken = new TokenImpl(att);
        class InitialFlow
        extends SequenceFlowImpl {
            InitialFlow(StartEvent start) {
                super(start.getName());
                this.setTargetRef((FlowObject)start);
            }
        }
        InitialFlow initialFlow = new InitialFlow(start);
        initialToken.setFlow(initialFlow);
        rtProc = this.getRuntimeProcess(proc, true);
        TokenExecutor tokenExecutor = rtProc.getTokenExecutor();
        tokenExecutor.create((Token)initialToken, (SequenceFlow)initialFlow);
        if (startProcessThread) {
            RunnableProcess runnable = new RunnableProcess(rtProc);
            this.getProcessExecutor().execute(runnable);
            Process process = proc;
            synchronized (process) {
                while (proc.getProcessStatus() != Process.ProcessStatus.Active) {
                    try {
                        proc.wait();
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        }
        this.startTimeAssignments(proc, initialToken);
        tokenExecutor.start((Token)initialToken);
    }

    private void startProcessPrepare(Process proc) {
        Process.ProcessStatus procStatus;
        ProcessImpl procImpl = (ProcessImpl)proc;
        if (this.isProcessTerminated(proc)) {
            procImpl.resetProcess();
        }
        if ((procStatus = proc.getProcessStatus()) != Process.ProcessStatus.Ready && procStatus != Process.ProcessStatus.Active) {
            throw new IllegalStateException("Cannot start process in state: " + procStatus);
        }
        ProcessManager pm = ProcessManager.locateProcessManager();
        if (pm.getProcessByID(proc.getID()) == null) {
            pm.registerProcess(proc);
        }
    }

    public Process.ProcessStatus waitForEnd(Process proc) {
        return this.waitForEndInternal(proc, 0L);
    }

    public Process.ProcessStatus waitForEnd(Process proc, long timeout) {
        return this.waitForEndInternal(proc, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process.ProcessStatus waitForEndInternal(Process proc, long timeout) {
        ProcessImpl procImpl = (ProcessImpl)proc;
        Process.ProcessStatus status = proc.getProcessStatus();
        if (status == Process.ProcessStatus.None) {
            throw new IllegalStateException("Cannot wait for process in state: " + status);
        }
        boolean forever = timeout < 1L;
        long now = System.currentTimeMillis();
        long until = now + timeout;
        try {
            while (forever || now < until) {
                Process process = proc;
                synchronized (process) {
                    if (this.isProcessTerminated(proc)) {
                        if (procImpl.getRuntimeException() != null) {
                            throw new BPMException("Process aborted", (Throwable)procImpl.getRuntimeException());
                        }
                        break;
                    }
                    long waitTimeout = forever ? 0L : until - now;
                    proc.wait(waitTimeout);
                }
                now = System.currentTimeMillis();
            }
            if (!this.isProcessTerminated(proc)) {
                ProcessTimeoutException rte = new ProcessTimeoutException("Process timeout after " + timeout + "ms for: " + proc.getID());
                procImpl.setRuntimeException((RuntimeException)rte);
                log.error((Object)rte);
                throw rte;
            }
        }
        catch (InterruptedException ex) {
            log.warn((Object)ex);
        }
        finally {
            ProcessManager procManager = ProcessManager.locateProcessManager();
            if (procManager.getProcessByID(proc.getID()) != null) {
                procManager.unregisterProcess(proc);
            }
        }
        status = proc.getProcessStatus();
        return status;
    }

    private boolean isProcessTerminated(Process proc) {
        Process.ProcessStatus status = proc.getProcessStatus();
        return status == Process.ProcessStatus.Cancelled || status == Process.ProcessStatus.Completed || status == Process.ProcessStatus.Aborted;
    }

    private StartEvent getNoneStartEvent(Process proc) {
        StartEvent start = null;
        for (StartEvent aux : proc.getFlowObjects(StartEvent.class)) {
            if (aux.getTrigger().size() != 0) continue;
            if (start != null) {
                throw new InvalidProcessException("Process cannot have multiple start events with no trigger");
            }
            start = aux;
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeProcess getRuntimeProcess(Process proc, boolean createNew) {
        RuntimeProcess rtProcess;
        Map<ObjectName, RuntimeProcess> map = this.runtimeProcesses;
        synchronized (map) {
            rtProcess = this.runtimeProcesses.get(proc.getID());
            if (rtProcess == null && createNew) {
                rtProcess = new RuntimeProcessImpl(proc);
                this.runtimeProcesses.put(proc.getID(), rtProcess);
            }
        }
        return rtProcess;
    }

    private void startTimeAssignments(Process proc, Token token) {
        DelegatingToken delegatingToken = new DelegatingToken((MutableToken)token);
        ExecutionContext exContext = token.getExecutionContext();
        for (Assignment ass : proc.getAssignments()) {
            if (ass.getAssignTime() != Assignment.AssignTime.Start) continue;
            Expression expr = ass.getFrom();
            ExpressionEvaluator exprEvaluator = new ExpressionEvaluator(expr);
            Object result = exprEvaluator.evaluateExpression(delegatingToken);
            String propName = ass.getTo().getName();
            exContext.addAttachment(propName, result);
        }
    }

    class RunnableProcess
    implements Runnable {
        private RuntimeProcess rtProc;

        public RunnableProcess(RuntimeProcess rtProc) {
            this.rtProc = rtProc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            TokenExecutor tokenExecutor = this.rtProc.getTokenExecutor();
            ProcessImpl procImpl = (ProcessImpl)this.rtProc.getProcess();
            Process proc = this.rtProc.getProcess();
            SignalManager signalManager = SignalManager.locateSignalManager();
            ObjectName procID = proc.getID();
            String procName = proc.getName();
            try {
                object = proc;
                synchronized (object) {
                    procImpl.setProcessStatus(Process.ProcessStatus.Active);
                    signalManager.throwSignal(new Signal(procID, Signal.SignalType.SYSTEM_PROCESS_ENTER));
                    proc.notifyAll();
                }
                object = this.rtProc;
                synchronized (object) {
                    while (tokenExecutor.hasRunnableTokens()) {
                        try {
                            this.rtProc.wait();
                        }
                        catch (InterruptedException ex) {
                            log.error((Object)ex);
                        }
                    }
                    log.debug((Object)("End execution thread [proc=" + procName + ",status=" + proc.getProcessStatus() + "]"));
                    if (proc.getProcessStatus() == Process.ProcessStatus.Active) {
                        procImpl.setProcessStatus(Process.ProcessStatus.Completed);
                    }
                }
            }
            finally {
                signalManager.throwSignal(new Signal(procID, Signal.SignalType.SYSTEM_PROCESS_EXIT));
                object = proc;
                synchronized (object) {
                    ProcessManager procManager = ProcessManager.locateProcessManager();
                    procManager.unregisterProcess(proc);
                    ExecutionManagerImpl.this.runtimeProcesses.remove(procID);
                    proc.notifyAll();
                }
            }
        }
    }
}

