/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NameNotUniqueException;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.ConnectingObject;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.SingleInFlowSupport;
import org.jboss.bpm.model.SingleOutFlowSupport;
import org.jboss.bpm.ri.model.impl.ExpressionEvaluator;
import org.jboss.bpm.ri.model.impl.GraphicalElementImpl;
import org.jboss.bpm.ri.model.impl.HandlerSetterSupport;
import org.jboss.bpm.ri.model.impl.MultipleInFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.MultipleInFlowSupport;
import org.jboss.bpm.ri.model.impl.MultipleOutFlowSupport;
import org.jboss.bpm.ri.model.impl.SequenceFlowImpl;
import org.jboss.bpm.ri.model.impl.SingleInFlowSetterSupport;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.ExecutionHandler;
import org.jboss.bpm.runtime.FlowHandler;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowObjectImpl
extends GraphicalElementImpl
implements FlowObject,
HandlerSetterSupport {
    private String name;
    private Process proc;
    private FlowHandler flowHandler;
    private SignalHandler signalHandler;
    private ExecutionHandler executionHandler;
    private List<Assignment> assignments = new ArrayList<Assignment>();

    public FlowObjectImpl(String name) {
        this.name = name;
    }

    public Process getProcess() {
        return this.proc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Assignment> getAssignments() {
        return Collections.unmodifiableList(this.assignments);
    }

    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public ExecutionHandler getExecutionHandler() {
        return this.executionHandler;
    }

    @Override
    public void setExecutionHandler(ExecutionHandler executionHandler) {
        this.executionHandler = executionHandler;
    }

    public FlowHandler getFlowHandler() {
        return this.flowHandler;
    }

    @Override
    public void setFlowHandler(FlowHandler flowHandler) {
        this.flowHandler = flowHandler;
    }

    public SignalHandler getSignalHandler() {
        return this.signalHandler;
    }

    @Override
    public void setSignalHandler(SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
    }

    public void execute(Token token) {
        this.startTimeAssignments(token);
        ExecutionHandler exHandler = this.getExecutionHandler();
        if (exHandler != null) {
            exHandler.execute(token);
        } else {
            this.defaultExecution(token);
        }
        this.endTimeAssignments(token);
    }

    protected void startTimeAssignments(Token token) {
        for (Assignment ass : this.getAssignments()) {
            if (ass.getAssignTime() != Assignment.AssignTime.Start) continue;
            this.processAssignment(ass, token);
        }
    }

    protected void endTimeAssignments(Token token) {
        for (Assignment ass : this.getAssignments()) {
            if (ass.getAssignTime() != Assignment.AssignTime.End) continue;
            this.processAssignment(ass, token);
        }
    }

    protected void processAssignment(Assignment ass, Token token) {
        Expression expr = ass.getFrom();
        ExpressionEvaluator exprEvaluator = new ExpressionEvaluator(expr);
        Object result = exprEvaluator.evaluateExpression(token);
        String propName = ass.getTo().getName();
        ExecutionContext exContext = token.getExecutionContext();
        exContext.addAttachment(propName, result);
    }

    public final void executeFlowHandler(TokenExecutor tokenExecutor, Token token) {
        FlowHandler flowHandler = this.getFlowHandler();
        if (flowHandler != null) {
            flowHandler.execute(tokenExecutor, token);
        } else {
            this.defaultFlowHandler(tokenExecutor, token);
        }
    }

    protected void defaultExecution(Token token) {
    }

    protected abstract void defaultFlowHandler(TokenExecutor var1, Token var2);

    public void reset() {
    }

    @Override
    protected void create(Process proc) {
        super.create(proc);
        this.proc = proc;
        if (this.name == null) {
            throw new InvalidProcessException("Name is required for: " + this);
        }
        for (FlowObject aux : proc.getFlowObjects()) {
            String auxName = aux.getName();
            if (aux == this || !this.name.equals(auxName)) continue;
            throw new NameNotUniqueException(this.toString());
        }
        SequenceFlow outFlow = null;
        if (this instanceof SingleOutFlowSupport) {
            SingleOutFlowSupport sof = (SingleOutFlowSupport)this;
            outFlow = sof.getOutFlow();
            this.initFlow(proc, (SequenceFlowImpl)outFlow);
        } else if (this instanceof MultipleOutFlowSupport) {
            MultipleOutFlowSupport mof = (MultipleOutFlowSupport)((Object)this);
            for (ConnectingObject flow : mof.getOutFlows()) {
                outFlow = flow;
                this.initFlow(proc, (SequenceFlowImpl)outFlow);
            }
        } else if (this instanceof Gateway) {
            Gateway gateway = (Gateway)this;
            for (Gate gate : gateway.getGates()) {
                outFlow = gate.getOutgoingSequenceFlow();
                this.initFlow(proc, (SequenceFlowImpl)outFlow);
            }
        }
        ConnectingObject inFlow = null;
        if (this instanceof SingleInFlowSupport) {
            SingleInFlowSupport sif = (SingleInFlowSupport)this;
            inFlow = sif.getInFlow();
        } else if (this instanceof MultipleInFlowSupport) {
            MultipleInFlowSupport mif = (MultipleInFlowSupport)((Object)this);
            Iterator<ConnectingObject> i$ = mif.getInFlows().iterator();
            while (i$.hasNext()) {
                ConnectingObject flow;
                inFlow = flow = i$.next();
            }
        }
        if (inFlow == null && outFlow == null) {
            throw new InvalidProcessException("Unconnected flow object: " + this);
        }
    }

    private void initFlow(Process proc, SequenceFlowImpl flow) {
        if (flow != null) {
            String name = flow.getTargetName();
            FlowObject target = proc.getFlowObject(name);
            if (target == null) {
                throw new InvalidProcessException("Cannot find target for out flow: " + name);
            }
            if (target instanceof SingleInFlowSetterSupport) {
                SingleInFlowSetterSupport sif = (SingleInFlowSetterSupport)target;
                sif.setInFlow(flow);
            } else if (target instanceof MultipleInFlowSetterSupport) {
                MultipleInFlowSetterSupport mif = (MultipleInFlowSetterSupport)target;
                mif.addInFlow(flow);
            } else {
                throw new InvalidProcessException("Target does not support in flow: " + target);
            }
            flow.setSourceRef(this);
            flow.setTargetRef(target);
        }
    }
}

