/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.model.impl.ExpressionImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.GateImpl;
import org.jboss.bpm.ri.model.impl.GatewayImpl;
import org.jboss.bpm.ri.model.impl.ProcessBuilderImpl;
import org.jboss.bpm.ri.model.impl.ProcessImpl;

public class GatewayBuilderImpl
extends ProcessBuilderImpl
implements GatewayBuilder {
    private Gate gate;

    public GatewayBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject) {
        super(proc, flowObject);
    }

    public GatewayBuilder addGate(String targetName) {
        this.gate = new GateImpl(targetName);
        this.getGateway().addGate(this.gate);
        return this;
    }

    public GatewayBuilder addConditionalGate(String targetName, Expression.ExpressionLanguage lang, String body) {
        this.gate = new GateImpl(targetName, SequenceFlow.ConditionType.Expression, new ExpressionImpl(lang, body));
        this.getGateway().addGate(this.gate);
        return this;
    }

    public GatewayBuilder addDefaultGate(String targetName) {
        this.gate = new GateImpl(targetName, SequenceFlow.ConditionType.Default, null);
        this.getGateway().addGate(this.gate);
        return this;
    }

    private GatewayImpl getGateway() {
        if (!(this.flowObject instanceof Gateway)) {
            throw new IllegalStateException("Last added flow object is not a Gateway: " + this.flowObject);
        }
        return (GatewayImpl)this.flowObject;
    }
}

