/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.model.TaskBuilder;
import org.jboss.bpm.ri.model.impl.AssignmentImpl;
import org.jboss.bpm.ri.model.impl.ComplexGatewayImpl;
import org.jboss.bpm.ri.model.impl.EndEventImpl;
import org.jboss.bpm.ri.model.impl.EventBuilderImpl;
import org.jboss.bpm.ri.model.impl.ExclusiveGatewayDataBasedImpl;
import org.jboss.bpm.ri.model.impl.ExpressionImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.GatewayBuilderImpl;
import org.jboss.bpm.ri.model.impl.HandlerSetterSupport;
import org.jboss.bpm.ri.model.impl.InclusiveGatewayImpl;
import org.jboss.bpm.ri.model.impl.IntermediateEventImpl;
import org.jboss.bpm.ri.model.impl.MessageBuilderImpl;
import org.jboss.bpm.ri.model.impl.MultipleOutFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.NoneTaskImpl;
import org.jboss.bpm.ri.model.impl.ParallelGatewayImpl;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.PropertyImpl;
import org.jboss.bpm.ri.model.impl.ReceiveTaskImpl;
import org.jboss.bpm.ri.model.impl.SendTaskImpl;
import org.jboss.bpm.ri.model.impl.SequenceFlowImpl;
import org.jboss.bpm.ri.model.impl.SingleOutFlowSetterSupport;
import org.jboss.bpm.ri.model.impl.StartEventImpl;
import org.jboss.bpm.ri.model.impl.TaskBuilderImpl;
import org.jboss.bpm.runtime.ExecutionHandler;
import org.jboss.bpm.runtime.FlowHandler;
import org.jboss.bpm.runtime.SignalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilderImpl
implements ProcessBuilder {
    protected ProcessImpl proc;
    protected FlowObjectImpl flowObject;

    public ProcessBuilderImpl() {
    }

    protected ProcessBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject) {
        this.proc = proc;
        this.flowObject = flowObject;
    }

    public ProcessBuilder addProcess(String procName) {
        this.proc = new ProcessImpl(procName);
        return this;
    }

    public ProcessBuilder addProcess(Process addProc) {
        ProcessImpl procImpl = (ProcessImpl)addProc;
        for (Message msg : procImpl.getMessages()) {
            this.getProcessInternal().addMessage(msg);
        }
        for (FlowObject fo : procImpl.getFlowObjects()) {
            this.getProcessInternal().addFlowObject(fo);
        }
        return this;
    }

    public Process getProcess() {
        ProcessImpl internalProc = this.getProcessInternal();
        internalProc.create(internalProc);
        return internalProc;
    }

    public Process getProcessForInclude() {
        return this.getProcessInternal();
    }

    public ProcessBuilder addSequenceFlow(String targetName) {
        if (this.flowObject instanceof SingleOutFlowSetterSupport) {
            SingleOutFlowSetterSupport outFlow = (SingleOutFlowSetterSupport)((Object)this.flowObject);
            outFlow.setOutFlow(new SequenceFlowImpl(targetName));
        } else if (this.flowObject instanceof MultipleOutFlowSetterSupport) {
            MultipleOutFlowSetterSupport outFlow = (MultipleOutFlowSetterSupport)((Object)this.flowObject);
            outFlow.addOutFlow(new SequenceFlowImpl(targetName));
        } else if (this.flowObject instanceof Gateway) {
            GatewayBuilderImpl gwBuilder = new GatewayBuilderImpl(this.getProcessInternal(), this.flowObject);
            gwBuilder.addGate(targetName);
        } else {
            throw new IllegalStateException("Cannot add a sequence flow to: " + this.flowObject);
        }
        return this;
    }

    public ProcessBuilder addMessageFlow(String targetName) {
        throw new NotImplementedException("JBPM-1382", "Message Flow");
    }

    public EventBuilder addStartEvent(String name) {
        this.flowObject = this.addFlowObject(new StartEventImpl(name));
        return new EventBuilderImpl(this.getProcessInternal(), this.flowObject);
    }

    public EventBuilder addEvent(String name) {
        this.flowObject = (FlowObjectImpl)this.getProcessInternal().getFlowObject(name);
        if (this.flowObject == null) {
            this.flowObject = this.addFlowObject(new IntermediateEventImpl(name));
        }
        return new EventBuilderImpl(this.getProcessInternal(), this.flowObject);
    }

    public EventBuilder addEndEvent(String name) {
        this.flowObject = (FlowObjectImpl)this.getProcessInternal().getFlowObject(name);
        if (this.flowObject == null) {
            this.flowObject = this.addFlowObject(new EndEventImpl(name));
        }
        return new EventBuilderImpl(this.getProcessInternal(), this.flowObject);
    }

    public TaskBuilder addTask(String name) {
        return this.addTask(name, Task.TaskType.None);
    }

    public TaskBuilder addTask(String name, Task.TaskType type) {
        this.flowObject = (FlowObjectImpl)this.getProcessInternal().getFlowObject(name);
        if (this.flowObject == null) {
            if (type == Task.TaskType.None || type == null) {
                this.flowObject = new NoneTaskImpl(name);
            } else {
                if (type == Task.TaskType.Service) {
                    throw new NotImplementedException("JBPM-1652", "Task Type Service");
                }
                if (type == Task.TaskType.Receive) {
                    this.flowObject = new ReceiveTaskImpl(name);
                } else if (type == Task.TaskType.Send) {
                    this.flowObject = new SendTaskImpl(name);
                } else {
                    if (type == Task.TaskType.User) {
                        throw new NotImplementedException("JBPM-1653", "Task Type User");
                    }
                    if (type == Task.TaskType.Script) {
                        throw new NotImplementedException("JBPM-1654", "Task Type Script");
                    }
                    if (type == Task.TaskType.Manual) {
                        throw new NotImplementedException("JBPM-1655", "Task Type Manual");
                    }
                    if (type == Task.TaskType.Reference) {
                        throw new NotImplementedException("JBPM-1656", "Task Type Reference");
                    }
                    throw new IllegalStateException("Task type: " + type);
                }
            }
            this.addFlowObject(this.flowObject);
        }
        return new TaskBuilderImpl(this.getProcessInternal(), this.flowObject);
    }

    public GatewayBuilder addGateway(String name, Gateway.GatewayType type) {
        this.flowObject = (FlowObjectImpl)this.getProcessInternal().getFlowObject(name);
        if (this.flowObject == null) {
            if (Gateway.GatewayType.Exclusive == type) {
                this.flowObject = new ExclusiveGatewayDataBasedImpl(name);
            } else if (Gateway.GatewayType.Inclusive == type) {
                this.flowObject = new InclusiveGatewayImpl(name);
            } else if (Gateway.GatewayType.Parallel == type) {
                this.flowObject = new ParallelGatewayImpl(name);
            } else if (Gateway.GatewayType.Complex == type) {
                this.flowObject = new ComplexGatewayImpl(name);
            }
            this.addFlowObject(this.flowObject);
        }
        return new GatewayBuilderImpl(this.getProcessInternal(), this.flowObject);
    }

    public MessageBuilder addMessage(String name) {
        MessageBuilder msgBuilder = new MessageBuilderImpl().newMessage(name);
        this.getProcessInternal().addMessage(msgBuilder.getMessage());
        return msgBuilder;
    }

    public ProcessBuilder addProperty(String name, String value) {
        PropertyImpl prop = new PropertyImpl(name, new ExpressionImpl(value));
        this.getProcessInternal().addProperty(prop);
        return this;
    }

    public ProcessBuilder addAssignment(Assignment.AssignTime time, Expression.ExpressionLanguage lang, String fromExpr, String toProp) {
        ExpressionImpl from = new ExpressionImpl(lang, fromExpr);
        PropertyImpl to = new PropertyImpl(toProp, null);
        AssignmentImpl assignment = new AssignmentImpl(time, from, to);
        if (this.flowObject != null) {
            this.flowObject.addAssignment(assignment);
        } else {
            this.getProcessInternal().addAssignment(assignment);
        }
        return this;
    }

    public ProcessBuilder addExecutionHandler(Class<?> clazz) {
        return this.addHandler(clazz);
    }

    public ProcessBuilder addFlowHandler(Class<?> clazz) {
        return this.addHandler(clazz);
    }

    public ProcessBuilder addSignalHandler(Class<?> clazz) {
        return this.addHandler(clazz);
    }

    private ProcessBuilder addHandler(Class<?> handlerClass) {
        block8: {
            if (!(this.flowObject instanceof HandlerSetterSupport)) {
                throw new IllegalStateException("Current flow object does not support handlers: " + this.flowObject);
            }
            if (handlerClass != null) {
                FlowObjectImpl hs = this.flowObject;
                try {
                    Object handler = handlerClass.newInstance();
                    if (handler instanceof ExecutionHandler) {
                        hs.setExecutionHandler((ExecutionHandler)handler);
                        break block8;
                    }
                    if (handler instanceof FlowHandler) {
                        hs.setFlowHandler((FlowHandler)handler);
                        break block8;
                    }
                    if (handler instanceof SignalHandler) {
                        hs.setSignalHandler((SignalHandler)handler);
                        break block8;
                    }
                    throw new IllegalArgumentException("Given class is not a supported handler");
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Cannot instanciate handler", ex);
                }
            }
        }
        return this;
    }

    private FlowObjectImpl addFlowObject(FlowObjectImpl fo) {
        this.getProcessInternal().addFlowObject(fo);
        return fo;
    }

    private ProcessImpl getProcessInternal() {
        if (this.proc == null) {
            throw new IllegalStateException("No process available");
        }
        return this.proc;
    }
}

