/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SendTask;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.ri.model.impl.MessageSender;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.TaskImpl;
import org.jboss.bpm.runtime.Token;

public class SendTaskImpl
extends TaskImpl
implements SendTask {
    private Message.Implementation implementation = Message.Implementation.WebService;
    private Message messageRef;

    public SendTaskImpl(String name) {
        super(name);
    }

    public Task.TaskType getTaskType() {
        return Task.TaskType.Send;
    }

    public Message.Implementation getImplementation() {
        return this.implementation;
    }

    public Message getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(Message message) {
        this.messageRef = message;
    }

    protected void defaultExecution(Token token) {
        super.defaultExecution(token);
        MessageSender messageSender = new MessageSender(this, this.messageRef);
        messageSender.sendMessage(token);
    }

    protected void create(Process proc) {
        super.create(proc);
        if (this.messageRef == null) {
            throw new InvalidProcessException("A Message for the MessageRef attribute MUST be entered");
        }
        ProcessImpl procImpl = (ProcessImpl)proc;
        procImpl.initializeMessageRef(this.messageRef);
        if (this.messageRef.getToRef() == null) {
            throw new IllegalArgumentException("Message targetID cannot be null for: " + this);
        }
    }
}

