/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.SignalListener;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.SignalEventDetail;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.ri.model.impl.EventDetailImpl;
import org.jboss.bpm.ri.model.impl.EventImpl;
import org.jboss.bpm.ri.model.impl.SingleOutFlowSetterSupport;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartEventImpl
extends EventImpl
implements StartEvent,
SingleOutFlowSetterSupport {
    private static final Log log = LogFactory.getLog(StartEventImpl.class);
    private SequenceFlow outFlow;
    private List<EventDetail> triggers = new ArrayList<EventDetail>();
    private SignalListener startListener;

    public StartEventImpl(String name) {
        super(name == null ? "Start" : name);
    }

    @Override
    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=StartEvent,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public List<EventDetail> getTrigger() {
        return Collections.unmodifiableList(this.triggers);
    }

    public void addTrigger(EventDetail eventDetail) {
        this.triggers.add(eventDetail);
    }

    public SequenceFlow getOutFlow() {
        return this.outFlow;
    }

    @Override
    public void setOutFlow(SequenceFlow flow) {
        this.outFlow = flow;
    }

    @Override
    protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token) {
        tokenExecutor.move(token, this.getOutFlow());
    }

    @Override
    public SignalHandler getSignalHandler() {
        SignalHandler handler = super.getSignalHandler();
        if (handler == null) {
            handler = new SignalHandler(){
                SignalManager signalManager = SignalManager.locateSignalManager();

                public void throwEnterSignal(Token token) {
                    Signal signal = new Signal(StartEventImpl.this.getID(), Signal.SignalType.SYSTEM_START_EVENT_ENTER);
                    this.signalManager.throwSignal(signal);
                }

                public void throwExitSignal(Token token) {
                    Signal signal = new Signal(StartEventImpl.this.getID(), Signal.SignalType.SYSTEM_START_EVENT_EXIT);
                    this.signalManager.throwSignal(signal);
                }
            };
        }
        return handler;
    }

    @Override
    protected void register(final Process proc) {
        super.register(proc);
        for (EventDetail eventDetail : this.getTrigger()) {
            EventDetailImpl eventDetailImpl = (EventDetailImpl)eventDetail;
            eventDetailImpl.initialize(this);
            if (!(eventDetail instanceof SignalEventDetail) || this.startListener != null) continue;
            SignalEventDetail signalEventDetail = (SignalEventDetail)eventDetail;
            final Signal startSignal = signalEventDetail.getSignalRef();
            final StartEventImpl start = this;
            this.startListener = new SignalListener(){

                public boolean acceptSignal(Signal signal) {
                    boolean accept;
                    Signal.SignalType expType = startSignal.getSignalType();
                    String expMsg = startSignal.getMessage();
                    String sigMsg = signal.getMessage();
                    Signal.SignalType sigType = signal.getSignalType();
                    boolean bl = accept = expType == sigType;
                    if (accept && expMsg != null) {
                        accept = accept && expMsg.equals(sigMsg);
                    }
                    return accept;
                }

                public void catchSignal(Signal signal) {
                    log.debug((Object)("catchSignal: " + signal));
                    Process.ProcessStatus procStatus = proc.getProcessStatus();
                    if (procStatus == Process.ProcessStatus.Ready || procStatus == Process.ProcessStatus.Active) {
                        log.debug((Object)("Start process from signal: " + signal));
                        ExecutionManager exManager = ExecutionManager.locateExecutionManager();
                        exManager.startProcess(start, null);
                    } else {
                        log.debug((Object)("Ignore start signal for process: " + proc));
                    }
                }

                public String toString() {
                    return start + "." + startSignal;
                }
            };
            SignalManager signalManager = SignalManager.locateSignalManager();
            signalManager.addSignalListener(this.startListener);
        }
    }

    @Override
    protected void unregister(Process proc) {
        if (this.startListener != null) {
            SignalManager signalManager = SignalManager.locateSignalManager();
            signalManager.removeSignalListener(this.startListener);
            this.startListener = null;
        }
        super.unregister(proc);
    }

    public String toString() {
        return "StartEvent[" + this.getName() + "]";
    }
}

